/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.sampler;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.sampler.SamplerType;

public class SamplerConfig {
    public static final String SAMPLER_ENABLE_NAME = "profiler.sampling.enable";
    private final boolean samplingEnable;
    private final SamplerType samplerType;

    public SamplerConfig(ProfilerConfig profilerConfig) {
        this.samplingEnable = profilerConfig.readBoolean(SAMPLER_ENABLE_NAME, true);
        String rateSamplerType = profilerConfig.readString("profiler.sampling.type", SamplerType.COUNTING.name());
        this.samplerType = SamplerType.of(rateSamplerType);
    }

    public boolean isSamplingEnable() {
        return this.samplingEnable;
    }

    public SamplerType getSamplerType() {
        return this.samplerType;
    }

    public String toString() {
        return "SamplerConfig{samplingEnable=" + this.samplingEnable + ", samplerType=" + (Object)((Object)this.samplerType) + '}';
    }
}

