/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.metadata;

import com.google.inject.Inject;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.provider.metadata.SimpleCacheFactory;
import com.navercorp.pinpoint.profiler.metadata.DefaultStringMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import java.util.Objects;
import javax.inject.Provider;

public class StringMetadataServiceProvider
implements Provider<StringMetaDataService> {
    private final EnhancedDataSender<MetaDataType> enhancedDataSender;
    private final SimpleCacheFactory simpleCacheFactory;

    @Inject
    public StringMetadataServiceProvider(@MetadataDataSender EnhancedDataSender<MetaDataType> enhancedDataSender, SimpleCacheFactory simpleCacheFactory) {
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        this.simpleCacheFactory = Objects.requireNonNull(simpleCacheFactory, "simpleCacheFactory");
    }

    public StringMetaDataService get() {
        SimpleCache<String> stringCache = this.simpleCacheFactory.newSimpleCache();
        return new DefaultStringMetaDataService(this.enhancedDataSender, stringCache);
    }
}

