/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.profiler.receiver.CommandDispatcher;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandLocatorBuilder;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadService;
import com.navercorp.pinpoint.profiler.receiver.service.EchoService;
import java.util.Objects;

public class CommandDispatcherProvider
implements Provider<CommandDispatcher> {
    private final ThriftTransportConfig thriftTransportConfig;
    private final ActiveTraceRepository activeTraceRepository;

    @Inject
    public CommandDispatcherProvider(ThriftTransportConfig thriftTransportConfig, Provider<ActiveTraceRepository> activeTraceRepositoryProvider) {
        this.thriftTransportConfig = Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
        Objects.requireNonNull(activeTraceRepositoryProvider, "activeTraceRepositoryProvider");
        this.activeTraceRepository = (ActiveTraceRepository)activeTraceRepositoryProvider.get();
    }

    public CommandDispatcher get() {
        ProfilerCommandLocatorBuilder builder = new ProfilerCommandLocatorBuilder();
        builder.addService(new EchoService());
        if (this.activeTraceRepository != null) {
            ActiveThreadService activeThreadService = new ActiveThreadService(this.thriftTransportConfig, this.activeTraceRepository);
            builder.addService(activeThreadService);
        }
        ProfilerCommandServiceLocator commandServiceLocator = builder.build();
        CommandDispatcher commandDispatcher = new CommandDispatcher(commandServiceLocator);
        return commandDispatcher;
    }
}

