/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.DefaultAsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.id.AsyncIdGenerator;
import com.navercorp.pinpoint.profiler.context.method.PredefinedMethodDescriptorRegistry;
import java.util.Objects;

public class AsyncContextFactoryProvider
implements Provider<AsyncContextFactory> {
    private final Provider<AsyncTraceContext> asyncTraceContextProvider;
    private final AsyncIdGenerator asyncIdGenerator;
    private final PredefinedMethodDescriptorRegistry predefinedMethodDescriptorRegistry;

    @Inject
    public AsyncContextFactoryProvider(Provider<AsyncTraceContext> asyncTraceContextProvider, AsyncIdGenerator asyncIdGenerator, PredefinedMethodDescriptorRegistry predefinedMethodDescriptorRegistry) {
        this.asyncTraceContextProvider = Objects.requireNonNull(asyncTraceContextProvider, "asyncTraceContextProvider");
        this.asyncIdGenerator = Objects.requireNonNull(asyncIdGenerator, "asyncIdGenerator");
        this.predefinedMethodDescriptorRegistry = Objects.requireNonNull(predefinedMethodDescriptorRegistry, "predefinedMethodDescriptorRegistry");
    }

    public AsyncContextFactory get() {
        AsyncTraceContext asyncTraceContext = (AsyncTraceContext)this.asyncTraceContextProvider.get();
        return new DefaultAsyncContextFactory(asyncTraceContext, this.asyncIdGenerator, this.predefinedMethodDescriptorRegistry);
    }
}

