/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.id.TransactionIdEncoder;
import com.navercorp.pinpoint.profiler.context.module.AgentDataSender;
import com.navercorp.pinpoint.profiler.context.module.DefaultClientFactory;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.module.ModuleLifeCycle;
import com.navercorp.pinpoint.profiler.context.module.ResultConverter;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.module.SpanStatChannelFactory;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.context.module.ThriftModuleLifeCycle;
import com.navercorp.pinpoint.profiler.context.provider.CommandDispatcherProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.ConnectionFactoryProviderProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.HeaderTBaseSerializerProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.MetadataMessageConverterProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.PinpointClientFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.SpanClientFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.SpanDataSenderProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.SpanProcessorProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.SpanStatChannelFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.SpanStatConnectTimerProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.StatClientFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.StatDataSenderProvider;
import com.navercorp.pinpoint.profiler.context.provider.thrift.TcpDataSenderProvider;
import com.navercorp.pinpoint.profiler.context.thrift.DefaultTransactionIdEncoder;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.SpanThriftMessageConverterProvider;
import com.navercorp.pinpoint.profiler.context.thrift.StatThriftMessageConverterProvider;
import com.navercorp.pinpoint.profiler.context.thrift.ThriftMessageToResultConverterProvider;
import com.navercorp.pinpoint.profiler.context.thrift.config.DefaultThriftTransportConfig;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.receiver.CommandDispatcher;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.ResultResponse;
import com.navercorp.pinpoint.rpc.client.ConnectionFactoryProvider;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.util.Timer;

public class ThriftModule
extends PrivateModule {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ProfilerConfig profilerConfig;

    public ThriftModule(ProfilerConfig profilerConfig) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
    }

    protected void configure() {
        this.logger.info("configure {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        ThriftTransportConfig thriftTransportConfig = this.loadThriftTransportConfig();
        this.bind(ThriftTransportConfig.class).toInstance((Object)thriftTransportConfig);
        this.bind(TransactionIdEncoder.class).to(DefaultTransactionIdEncoder.class).in(Scopes.SINGLETON);
        Key commandDispatcher = Key.get(CommandDispatcher.class);
        this.bind(commandDispatcher).toProvider(CommandDispatcherProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<SpanProcessor<TSpan, TSpanChunk>> spanPostProcessorType = new TypeLiteral<SpanProcessor<TSpan, TSpanChunk>>(){};
        this.bind((TypeLiteral)spanPostProcessorType).toProvider(SpanProcessorProvider.class).in(Scopes.SINGLETON);
        this.bind(ConnectionFactoryProvider.class).toProvider(ConnectionFactoryProviderProvider.class).in(Scopes.SINGLETON);
        Key pinpointClientFactory = Key.get(PinpointClientFactory.class, DefaultClientFactory.class);
        this.bind(pinpointClientFactory).toProvider(PinpointClientFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(HeaderTBaseSerializer.class).toProvider(HeaderTBaseSerializerProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<EnhancedDataSender<MetaDataType>> dataSenderTypeLiteral = new TypeLiteral<EnhancedDataSender<MetaDataType>>(){};
        this.bind((TypeLiteral)dataSenderTypeLiteral).toProvider(TcpDataSenderProvider.class).in(Scopes.SINGLETON);
        this.expose((TypeLiteral)dataSenderTypeLiteral);
        Key agentDataSender = Key.get((TypeLiteral)dataSenderTypeLiteral, AgentDataSender.class);
        this.bind(agentDataSender).to((TypeLiteral)dataSenderTypeLiteral).in(Scopes.SINGLETON);
        this.expose(agentDataSender);
        Key metadataDataSender = Key.get((TypeLiteral)dataSenderTypeLiteral, MetadataDataSender.class);
        this.bind(metadataDataSender).to((TypeLiteral)dataSenderTypeLiteral).in(Scopes.SINGLETON);
        this.expose(metadataDataSender);
        Key spanStatConnectTimer = Key.get(Timer.class, SpanStatChannelFactory.class);
        this.bind(spanStatConnectTimer).toProvider(SpanStatConnectTimerProvider.class).in(Scopes.SINGLETON);
        Key spanStatChannelFactory = Key.get(ChannelFactory.class, SpanStatChannelFactory.class);
        this.bind(spanStatChannelFactory).toProvider(SpanStatChannelFactoryProvider.class).in(Scopes.SINGLETON);
        Key spanClientFactory = Key.get(PinpointClientFactory.class, SpanDataSender.class);
        this.bind(spanClientFactory).toProvider(SpanClientFactoryProvider.class).in(Scopes.SINGLETON);
        Key statClientFactory = Key.get(PinpointClientFactory.class, StatDataSender.class);
        this.bind(statClientFactory).toProvider(StatClientFactoryProvider.class).in(Scopes.SINGLETON);
        TypeLiteral thriftMessageConverter = new TypeLiteral<MessageConverter<SpanType, TBase<?, ?>>>(){};
        Key spanMessageConverterKey = Key.get((TypeLiteral)thriftMessageConverter, SpanDataSender.class);
        this.bind(spanMessageConverterKey).toProvider(SpanThriftMessageConverterProvider.class).in(Scopes.SINGLETON);
        TypeLiteral metadataMessageConverter = new TypeLiteral<MessageConverter<MetaDataType, TBase<?, ?>>>(){};
        Key metadataMessageConverterKey = Key.get((TypeLiteral)metadataMessageConverter, MetadataDataSender.class);
        this.bind(metadataMessageConverterKey).toProvider(MetadataMessageConverterProvider.class).in(Scopes.SINGLETON);
        TypeLiteral statMessageConverter = new TypeLiteral<MessageConverter<MetricType, TBase<?, ?>>>(){};
        Key statMessageConverterKey = Key.get((TypeLiteral)statMessageConverter, StatDataSender.class);
        this.bind(statMessageConverterKey).toProvider(StatThriftMessageConverterProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<DataSender<SpanType>> spanDataSenderType = new TypeLiteral<DataSender<SpanType>>(){};
        Key spanDataSender = Key.get((TypeLiteral)spanDataSenderType, SpanDataSender.class);
        this.bind(spanDataSender).toProvider(SpanDataSenderProvider.class).in(Scopes.SINGLETON);
        this.expose(spanDataSender);
        TypeLiteral<DataSender<MetricType>> statDataSenderType = new TypeLiteral<DataSender<MetricType>>(){};
        Key statDataSender = Key.get((TypeLiteral)statDataSenderType, StatDataSender.class);
        this.bind(statDataSender).toProvider(StatDataSenderProvider.class).in(Scopes.SINGLETON);
        this.expose(statDataSender);
        TypeLiteral<MessageConverter<Object, ResultResponse>> resultMessageConverter = new TypeLiteral<MessageConverter<Object, ResultResponse>>(){};
        Key resultMessageConverterKey = Key.get((TypeLiteral)resultMessageConverter, ResultConverter.class);
        this.bind(resultMessageConverterKey).toProvider(ThriftMessageToResultConverterProvider.class).in(Scopes.SINGLETON);
        this.expose(resultMessageConverterKey);
        Key rpcModuleLifeCycleKey = Key.get(ModuleLifeCycle.class, (Annotation)Names.named((String)"RPC-MODULE"));
        this.bind(rpcModuleLifeCycleKey).to(ThriftModuleLifeCycle.class).in(Scopes.SINGLETON);
        this.expose(rpcModuleLifeCycleKey);
    }

    public ThriftTransportConfig loadThriftTransportConfig() {
        DefaultThriftTransportConfig thriftTransportConfig = new DefaultThriftTransportConfig();
        thriftTransportConfig.read(this.profilerConfig.getProperties());
        this.logger.info("{}", (Object)thriftTransportConfig);
        return thriftTransportConfig;
    }
}

