/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.bootstrap.context.ServerMetaData;
import com.navercorp.pinpoint.bootstrap.context.ServiceInfo;
import com.navercorp.pinpoint.grpc.trace.PAgentInfo;
import com.navercorp.pinpoint.grpc.trace.PJvmGcType;
import com.navercorp.pinpoint.grpc.trace.PJvmInfo;
import com.navercorp.pinpoint.grpc.trace.PServerMetaData;
import com.navercorp.pinpoint.grpc.trace.PServiceInfo;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.JvmInformation;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcJvmGcTypeMessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.metadata.AgentInfo;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import java.util.ArrayList;

public class GrpcAgentInfoMessageConverter
implements MessageConverter<MetaDataType, GeneratedMessageV3> {
    private final GrpcJvmGcTypeMessageConverter jvmGcTypeMessageConverter = new GrpcJvmGcTypeMessageConverter();

    @Override
    public GeneratedMessageV3 toMessage(MetaDataType message) {
        if (message instanceof AgentInfo) {
            AgentInfo agentInfo = (AgentInfo)message;
            return this.convertAgentInfo(agentInfo);
        }
        return null;
    }

    public PAgentInfo convertAgentInfo(AgentInfo agentInfo) {
        JvmInformation jvmInformation;
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        PAgentInfo.Builder builder = PAgentInfo.newBuilder();
        builder.setIp(agentInformation.getHostIp());
        builder.setHostname(agentInformation.getMachineName());
        builder.setPorts("");
        builder.setContainer(agentInformation.isContainer());
        builder.setPid(agentInformation.getPid());
        builder.setServiceType((int)agentInformation.getServerType().getCode());
        builder.setVmVersion(agentInformation.getJvmVersion());
        builder.setAgentVersion("2.4.1");
        ServerMetaData serverMetaData = agentInfo.getServerMetaData();
        if (serverMetaData != null) {
            PServerMetaData tServerMetaData = this.convertServerMetaData(agentInfo.getServerMetaData());
            builder.setServerMetaData(tServerMetaData);
        }
        if ((jvmInformation = agentInfo.getJvmInfo()) != null) {
            PJvmInfo tJvmInfo = this.convertJvmInfo(agentInfo.getJvmInfo());
            builder.setJvmInfo(tJvmInfo);
        }
        return builder.build();
    }

    private PServerMetaData convertServerMetaData(ServerMetaData serverMetaData) {
        PServerMetaData.Builder serverMetaDataBuilder = PServerMetaData.newBuilder();
        serverMetaDataBuilder.setServerInfo(serverMetaData.getServerInfo());
        serverMetaDataBuilder.addAllVmArg((Iterable)serverMetaData.getVmArgs());
        ArrayList<PServiceInfo> serviceInfoList = new ArrayList<PServiceInfo>();
        for (ServiceInfo serviceInfo : serverMetaData.getServiceInfos()) {
            PServiceInfo.Builder serviceInfoBuilder = PServiceInfo.newBuilder();
            serviceInfoBuilder.setServiceName(serviceInfo.getServiceName());
            serviceInfoBuilder.addAllServiceLib((Iterable)serviceInfo.getServiceLibs());
            serviceInfoList.add(serviceInfoBuilder.build());
        }
        serverMetaDataBuilder.addAllServiceInfo(serviceInfoList);
        return serverMetaDataBuilder.build();
    }

    private PJvmInfo convertJvmInfo(JvmInformation jvmInformation) {
        PJvmInfo.Builder builder = PJvmInfo.newBuilder();
        builder.setVmVersion(jvmInformation.getJvmVersion());
        PJvmGcType gcType = this.jvmGcTypeMessageConverter.toMessage((Object)jvmInformation.getJvmGcType());
        builder.setGcType(gcType);
        return builder.build();
    }
}

