/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.annotation;

import com.navercorp.pinpoint.grpc.trace.PAnnotationValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationSerializable;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.thrift.AnnotationValueThriftMapper;
import com.navercorp.pinpoint.profiler.context.thrift.ThriftAnnotationSerializable;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;

public class ShortAnnotation
implements Annotation<Short>,
GrpcAnnotationSerializable,
ThriftAnnotationSerializable {
    private final int key;
    private final short value;

    ShortAnnotation(int key, short value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getAnnotationKey() {
        return this.getKey();
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public PAnnotationValue apply(GrpcAnnotationValueMapper context) {
        PAnnotationValue.Builder builder = context.getAnnotationBuilder();
        builder.setShortValue((int)this.value);
        return builder.build();
    }

    @Override
    public TAnnotationValue apply(AnnotationValueThriftMapper context) {
        return TAnnotationValue.shortValue((short)this.value);
    }

    public String toString() {
        return "ShortAnnotation{" + this.key + "=" + this.value + '}';
    }
}

