/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcContext;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.TraceFactory;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTraceContext
implements TraceContext {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final TraceIdFactory traceIdFactory;
    private final TraceFactory traceFactory;
    private final AgentInformation agentInformation;
    private final ApiMetaDataService apiMetaDataService;
    private final StringMetaDataService stringMetaDataService;
    private final SqlMetaDataService sqlMetaDataService;
    private final ProfilerConfig profilerConfig;
    private final ServerMetaDataHolder serverMetaDataHolder;
    private final JdbcContext jdbcContext;

    public DefaultTraceContext(ProfilerConfig profilerConfig, AgentInformation agentInformation, TraceIdFactory traceIdFactory, TraceFactory traceFactory, ServerMetaDataHolder serverMetaDataHolder, ApiMetaDataService apiMetaDataService, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, JdbcContext jdbcContext) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.agentInformation = Objects.requireNonNull(agentInformation, "agentInformation");
        this.serverMetaDataHolder = Objects.requireNonNull(serverMetaDataHolder, "serverMetaDataHolder");
        this.traceIdFactory = Objects.requireNonNull(traceIdFactory, "traceIdFactory");
        this.traceFactory = Objects.requireNonNull(traceFactory, "traceFactory");
        this.jdbcContext = Objects.requireNonNull(jdbcContext, "jdbcContext");
        this.apiMetaDataService = Objects.requireNonNull(apiMetaDataService, "apiMetaDataService");
        this.stringMetaDataService = Objects.requireNonNull(stringMetaDataService, "stringMetaDataService");
        this.sqlMetaDataService = Objects.requireNonNull(sqlMetaDataService, "sqlMetaDataService");
    }

    public Trace currentTraceObject() {
        return this.traceFactory.currentTraceObject();
    }

    public Trace currentRawTraceObject() {
        return this.traceFactory.currentRawTraceObject();
    }

    public Trace disableSampling() {
        return this.traceFactory.disableSampling();
    }

    public ProfilerConfig getProfilerConfig() {
        return this.profilerConfig;
    }

    public Trace continueTraceObject(TraceId traceId) {
        return this.traceFactory.continueTraceObject(traceId);
    }

    public Trace continueTraceObject(Trace trace) {
        return this.traceFactory.continueTraceObject(trace);
    }

    public Trace newTraceObject() {
        return this.traceFactory.newTraceObject();
    }

    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        return this.traceFactory.newAsyncTraceObject();
    }

    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        return this.traceFactory.continueAsyncTraceObject(traceId);
    }

    public Trace removeTraceObject() {
        return this.removeTraceObject(true);
    }

    public Trace removeTraceObject(boolean closeUnsampledTrace) {
        Trace trace = this.traceFactory.removeTraceObject();
        if (closeUnsampledTrace) {
            return this.closeUnsampledTrace(trace);
        }
        return trace;
    }

    private Trace closeUnsampledTrace(Trace trace) {
        if (trace == null) {
            return null;
        }
        if (!trace.canSampled() && !trace.isClosed()) {
            trace.close();
        }
        return trace;
    }

    public String getAgentId() {
        return this.agentInformation.getAgentId();
    }

    public String getApplicationName() {
        return this.agentInformation.getApplicationName();
    }

    public long getAgentStartTime() {
        return this.agentInformation.getStartTime();
    }

    public short getServerTypeCode() {
        return this.agentInformation.getServerType().getCode();
    }

    public String getServerType() {
        return this.agentInformation.getServerType().getDesc();
    }

    public int cacheApi(MethodDescriptor methodDescriptor) {
        return this.apiMetaDataService.cacheApi(methodDescriptor);
    }

    public int cacheString(String value) {
        return this.stringMetaDataService.cacheString(value);
    }

    public TraceId createTraceId(String transactionId, long parentSpanId, long spanId, short flags) {
        Objects.requireNonNull(transactionId, "transactionId");
        return this.traceIdFactory.continueTraceId(transactionId, parentSpanId, spanId, flags);
    }

    public ParsingResult parseSql(String sql) {
        return this.sqlMetaDataService.parseSql(sql);
    }

    public boolean cacheSql(ParsingResult parsingResult) {
        return this.sqlMetaDataService.cacheSql(parsingResult);
    }

    public ServerMetaDataHolder getServerMetaDataHolder() {
        return this.serverMetaDataHolder;
    }

    public JdbcContext getJdbcContext() {
        return this.jdbcContext;
    }
}

