/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.body.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.utils.JsonUtils;

public class HeartbeatRequestBody
extends Body {
    public static final String CLIENTTYPE = "clientType";
    public static final String HEARTBEATENTITIES = "heartbeatEntities";
    public static final String CONSUMERGROUP = "consumerGroup";
    private String consumerGroup;
    private String clientType;
    private List<HeartbeatEntity> heartbeatEntities;

    public static HeartbeatRequestBody buildBody(Map<String, Object> bodyParam) {
        HeartbeatRequestBody body = new HeartbeatRequestBody();
        body.setClientType(MapUtils.getString(bodyParam, (Object)CLIENTTYPE));
        body.setConsumerGroup(MapUtils.getString(bodyParam, (Object)CONSUMERGROUP));
        body.setHeartbeatEntities(JsonUtils.parseTypeReferenceObject(MapUtils.getString(bodyParam, (Object)HEARTBEATENTITIES), new TypeReference<List<HeartbeatEntity>>(){}));
        return body;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CLIENTTYPE, this.clientType);
        map.put(CONSUMERGROUP, this.consumerGroup);
        map.put(HEARTBEATENTITIES, JsonUtils.toJSONString(this.heartbeatEntities));
        return map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeartbeatRequestBody)) {
            return false;
        }
        HeartbeatRequestBody other = (HeartbeatRequestBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$consumerGroup = this.getConsumerGroup();
        String other$consumerGroup = other.getConsumerGroup();
        if (this$consumerGroup == null ? other$consumerGroup != null : !this$consumerGroup.equals(other$consumerGroup)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        List<HeartbeatEntity> this$heartbeatEntities = this.getHeartbeatEntities();
        List<HeartbeatEntity> other$heartbeatEntities = other.getHeartbeatEntities();
        return !(this$heartbeatEntities == null ? other$heartbeatEntities != null : !((Object)this$heartbeatEntities).equals(other$heartbeatEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeartbeatRequestBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $consumerGroup = this.getConsumerGroup();
        result = result * 59 + ($consumerGroup == null ? 43 : $consumerGroup.hashCode());
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        List<HeartbeatEntity> $heartbeatEntities = this.getHeartbeatEntities();
        result = result * 59 + ($heartbeatEntities == null ? 43 : ((Object)$heartbeatEntities).hashCode());
        return result;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getClientType() {
        return this.clientType;
    }

    public List<HeartbeatEntity> getHeartbeatEntities() {
        return this.heartbeatEntities;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setHeartbeatEntities(List<HeartbeatEntity> heartbeatEntities) {
        this.heartbeatEntities = heartbeatEntities;
    }

    public String toString() {
        return "HeartbeatRequestBody(consumerGroup=" + this.getConsumerGroup() + ", clientType=" + this.getClientType() + ", heartbeatEntities=" + this.getHeartbeatEntities() + ")";
    }

    public static class HeartbeatEntity {
        public String topic;
        public String serviceId;
        public String url;
        public String instanceId;

        public String toString() {
            return "HeartbeatRequestBody.HeartbeatEntity(topic=" + this.topic + ", serviceId=" + this.serviceId + ", url=" + this.url + ", instanceId=" + this.instanceId + ")";
        }
    }
}

