/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.mongodb.producer;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.storage.mongodb.client.MongodbClientManager;
import org.apache.eventmesh.storage.mongodb.config.ConfigurationHolder;
import org.apache.eventmesh.storage.mongodb.exception.MongodbStorageException;
import org.apache.eventmesh.storage.mongodb.utils.MongodbCloudEventUtil;
import org.apache.eventmesh.storage.mongodb.utils.MongodbSequenceUtil;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbStandaloneProducer
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(MongodbStandaloneProducer.class);
    private final ConfigurationHolder configurationHolder;
    private volatile boolean started = false;
    private MongoClient client;
    private MongoDatabase db;
    private MongoCollection<Document> cappedCol;
    private MongodbSequenceUtil mongodbSequenceUtil;

    public MongodbStandaloneProducer(ConfigurationHolder configurationHolder) {
        this.configurationHolder = configurationHolder;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public void shutdown() {
        if (this.started) {
            try {
                MongodbClientManager.closeMongodbClient(this.client);
            }
            finally {
                this.started = false;
            }
        }
    }

    public void init(Properties keyValue) {
        this.client = MongodbClientManager.createMongodbClient(this.configurationHolder.getUrl());
        this.db = this.client.getDatabase(this.configurationHolder.getDatabase());
        this.cappedCol = this.db.getCollection(this.configurationHolder.getCollection());
        this.mongodbSequenceUtil = new MongodbSequenceUtil(this.configurationHolder);
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) {
        try {
            Document doc = MongodbCloudEventUtil.convertToDocument(cloudEvent);
            int i = this.mongodbSequenceUtil.getNextSeq("flag");
            doc.append("topic", (Object)"flag").append("ts", (Object)i);
            this.cappedCol.insertOne((Object)doc);
            SendResult sendResult = new SendResult();
            sendResult.setTopic(cloudEvent.getSubject());
            sendResult.setMessageId(cloudEvent.getId());
            sendCallback.onSuccess(sendResult);
        }
        catch (Exception ex) {
            log.error("[MongodbStandaloneProducer] publish happen exception.", (Throwable)ex);
            sendCallback.onException(OnExceptionContext.builder().topic(cloudEvent.getSubject()).messageId(cloudEvent.getId()).exception((StorageRuntimeException)new MongodbStorageException(ex)).build());
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        try {
            Document doc = MongodbCloudEventUtil.convertToDocument(cloudEvent);
            int i = this.mongodbSequenceUtil.getNextSeq("flag");
            doc.append("topic", (Object)"flag").append("ts", (Object)i);
            this.cappedCol.insertOne((Object)doc);
        }
        catch (Exception ex) {
            log.error("[MongodbStandaloneProducer] sendOneway happen exception.", (Throwable)ex);
        }
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        return false;
    }

    public void checkTopicExist(String topic) throws Exception {
    }

    public void setExtFields() {
    }
}

