/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.patch;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.storage.rocketmq.patch.EventMeshConsumeConcurrentlyContext;
import org.apache.eventmesh.storage.rocketmq.patch.EventMeshConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventMeshMessageListenerConcurrently
implements MessageListenerConcurrently {
    private static final Logger log = LoggerFactory.getLogger(EventMeshMessageListenerConcurrently.class);

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        ConsumeConcurrentlyStatus status = null;
        if (CollectionUtils.isEmpty(msgs)) {
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
        MessageExt msg = msgs.get(0);
        EventMeshConsumeConcurrentlyContext eventMeshConsumeConcurrentlyContext = (EventMeshConsumeConcurrentlyContext)context;
        EventMeshConsumeConcurrentlyStatus eventMeshConsumeStatus = this.handleMessage(msg, eventMeshConsumeConcurrentlyContext);
        try {
            switch (eventMeshConsumeStatus) {
                case CONSUME_SUCCESS: {
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                case RECONSUME_LATER: {
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
                case CONSUME_FINISH: {
                    eventMeshConsumeConcurrentlyContext.setManualAck(true);
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
            }
            return status;
        }
        catch (Throwable e) {
            try {
                log.info("handleMessage fail", e);
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
            catch (Throwable e2) {
                log.info("handleMessage fail", e2);
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        }
    }

    public abstract EventMeshConsumeConcurrentlyStatus handleMessage(MessageExt var1, EventMeshConsumeConcurrentlyContext var2);
}

