/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.consumer;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.rocketmq.config.ClientConfiguration;
import org.apache.eventmesh.storage.rocketmq.consumer.PushConsumerImpl;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config(field="clientConfiguration")
public class RocketMQConsumerImpl
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQConsumerImpl.class);
    private PushConsumerImpl pushConsumer;
    private ClientConfiguration clientConfiguration;

    public synchronized void init(Properties keyValue) {
        boolean isBroadcast = Boolean.parseBoolean(keyValue.getProperty("isBroadcast"));
        String consumerGroup = keyValue.getProperty("consumerGroup");
        if (isBroadcast) {
            consumerGroup = "broadcast-" + consumerGroup;
        }
        String namesrvAddr = this.clientConfiguration.getNamesrvAddr();
        String instanceName = keyValue.getProperty("instanceName");
        Properties properties = new Properties();
        properties.put("ACCESS_POINTS", namesrvAddr);
        properties.put("REGION", "namespace");
        properties.put("instanceName", instanceName);
        properties.put("CONSUMER_ID", consumerGroup);
        if (isBroadcast) {
            properties.put("MESSAGE_MODEL", MessageModel.BROADCASTING.name());
        } else {
            properties.put("MESSAGE_MODEL", MessageModel.CLUSTERING.name());
        }
        this.pushConsumer = new PushConsumerImpl(properties);
    }

    public void subscribe(String topic) {
        this.pushConsumer.subscribe(topic, "*");
    }

    public boolean isStarted() {
        return this.pushConsumer.isStarted();
    }

    public boolean isClosed() {
        return this.pushConsumer.isClosed();
    }

    public synchronized void start() {
        this.pushConsumer.start();
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        this.pushConsumer.updateOffset(cloudEvents, context);
    }

    public void unsubscribe(String topic) {
        this.pushConsumer.unsubscribe(topic);
    }

    public void registerEventListener(EventListener listener) {
        this.pushConsumer.registerEventListener(listener);
    }

    public synchronized void shutdown() {
        this.pushConsumer.shutdown();
    }

    public Properties attributes() {
        return this.pushConsumer.attributes();
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }
}

