/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.DeepDifference;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.introspection.IntrospectionError;

public class RecursiveFieldByFieldComparator
implements Comparator<Object> {
    private static final int NOT_EQUAL = -1;
    private final Map<String, Comparator<?>> comparatorByPropertyOrField;
    private final TypeComparators comparatorByType;

    public RecursiveFieldByFieldComparator(Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        this.comparatorByPropertyOrField = comparatorByPropertyOrField;
        this.comparatorByType = this.isNullOrEmpty(comparatorByType) ? AbstractObjectAssert.defaultTypeComparators() : comparatorByType;
    }

    private boolean isNullOrEmpty(TypeComparators comparatorByType) {
        return comparatorByType == null || comparatorByType.isEmpty();
    }

    @Override
    public int compare(Object actual, Object other) {
        if (actual == null && other == null) {
            return 0;
        }
        if (actual == null || other == null) {
            return -1;
        }
        return this.areEqual(actual, other) ? 0 : -1;
    }

    protected boolean areEqual(Object actual, Object other) {
        try {
            return DeepDifference.determineDifferences(actual, other, this.comparatorByPropertyOrField, this.comparatorByType).isEmpty();
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    public String toString() {
        return "recursive field/property by field/property comparator on all fields/properties";
    }
}

