/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Shorts;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractShortAssert<S extends AbstractShortAssert<S>>
extends AbstractComparableAssert<S, Short>
implements NumberAssert<S, Short> {
    @VisibleForTesting
    Shorts shorts = Shorts.instance();

    public AbstractShortAssert(Short actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualTo(short expected) {
        this.shorts.assertEqual(this.info, this.actual, expected);
        return (S)((AbstractShortAssert)this.myself);
    }

    public S isNotEqualTo(short other) {
        this.shorts.assertNotEqual(this.info, this.actual, other);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isZero() {
        this.shorts.assertIsZero(this.info, (Number)this.actual);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNotZero() {
        this.shorts.assertIsNotZero(this.info, (Number)this.actual);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isPositive() {
        this.shorts.assertIsPositive(this.info, (Number)this.actual);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNegative() {
        this.shorts.assertIsNegative(this.info, (Number)this.actual);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNotNegative() {
        this.shorts.assertIsNotNegative(this.info, (Number)this.actual);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNotPositive() {
        this.shorts.assertIsNotPositive(this.info, (Number)this.actual);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isLessThan(short other) {
        this.shorts.assertLessThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(short other) {
        this.shorts.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isGreaterThan(short other) {
        this.shorts.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(short other) {
        this.shorts.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isBetween(Short start, Short end) {
        this.shorts.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isStrictlyBetween(Short start, Short end) {
        this.shorts.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isCloseTo(short expected, Offset<Short> offset) {
        this.shorts.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(short expected, Offset<Short> offset) {
        this.shorts.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isCloseTo(Short expected, Offset<Short> offset) {
        this.shorts.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(Short expected, Offset<Short> offset) {
        this.shorts.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isCloseTo(Short expected, Percentage percentage) {
        this.shorts.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(Short expected, Percentage percentage) {
        this.shorts.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isCloseTo(short expected, Percentage percentage) {
        this.shorts.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(short expected, Percentage percentage) {
        this.shorts.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super Short> customComparator) {
        super.usingComparator(customComparator);
        this.shorts = new Shorts(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractShortAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.shorts = Shorts.instance();
        return (S)((AbstractShortAssert)this.myself);
    }
}

