/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookOperationConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookFileListener {
    private static final Logger log = LoggerFactory.getLogger(WebhookFileListener.class);
    private final transient Set<String> pathSet = new LinkedHashSet<String>();
    private final transient Map<WatchKey, String> watchKeyPathMap = new ConcurrentHashMap<WatchKey, String>();
    private transient String filePath;
    private transient Map<String, WebHookConfig> cacheWebHookConfig;

    public WebhookFileListener(String filePath, Map<String, WebHookConfig> cacheWebHookConfig) {
        this.filePath = WebHookOperationConstant.getFilePath((String)filePath);
        this.cacheWebHookConfig = cacheWebHookConfig;
        this.filePatternInit();
    }

    private void filePatternInit() {
        File webHookFileDir = new File(this.filePath);
        if (!webHookFileDir.exists()) {
            webHookFileDir.mkdirs();
        } else {
            this.readFiles(webHookFileDir);
        }
        this.fileWatchRegister();
    }

    private void readFiles(File file) {
        File[] fs = file.listFiles();
        for (File f : Objects.requireNonNull(fs)) {
            if (f.isDirectory()) {
                this.readFiles(f);
                continue;
            }
            if (!f.isFile()) continue;
            this.cacheInit(f);
        }
    }

    private void cacheInit(File webhookConfigFile) {
        StringBuilder fileContent = new StringBuilder();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(webhookConfigFile.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);){
            while (br.ready()) {
                fileContent.append(br.readLine());
            }
        }
        catch (IOException e) {
            log.error("cacheInit failed", (Throwable)e);
        }
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.parseObject((String)fileContent.toString(), WebHookConfig.class);
        this.cacheWebHookConfig.put(webhookConfigFile.getName(), webHookConfig);
    }

    public void deleteConfig(File webhookConfigFile) {
        this.cacheWebHookConfig.remove(webhookConfigFile.getName());
    }

    private void fileWatchRegister() {
        ExecutorService cachedThreadPool = Executors.newFixedThreadPool(1);
        cachedThreadPool.execute(() -> {
            WatchKey key;
            File root = new File(this.filePath);
            this.loopDirInsertToSet(root, this.pathSet);
            WatchService service = null;
            try {
                service = FileSystems.getDefault().newWatchService();
            }
            catch (Exception e) {
                log.error("getWatchService failed.", (Throwable)e);
            }
            for (String path : this.pathSet) {
                WatchKey key2 = null;
                try {
                    key2 = Paths.get(path, new String[0]).register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                }
                catch (IOException e) {
                    log.error("registerWatchKey failed", (Throwable)e);
                }
                this.watchKeyPathMap.put(key2, path);
            }
            do {
                key = null;
                try {
                    assert (service != null);
                    key = service.take();
                }
                catch (InterruptedException e) {
                    log.error("Interrupted", (Throwable)e);
                }
                assert (key != null);
                for (WatchEvent<?> event : key.pollEvents()) {
                    String flashPath = this.watchKeyPathMap.get(key);
                    String path = flashPath.concat("/").concat(event.context().toString());
                    File file = new File(path);
                    if (StandardWatchEventKinds.ENTRY_CREATE == event.kind() || StandardWatchEventKinds.ENTRY_MODIFY == event.kind()) {
                        if (file.isFile()) {
                            this.cacheInit(file);
                            continue;
                        }
                        try {
                            key = Paths.get(path, new String[0]).register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                            this.watchKeyPathMap.put(key, path);
                        }
                        catch (IOException e) {
                            log.error("registerWatchKey failed", (Throwable)e);
                        }
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_DELETE != event.kind()) continue;
                    if (file.isDirectory()) {
                        this.watchKeyPathMap.remove(key);
                        continue;
                    }
                    this.deleteConfig(file);
                }
            } while (key.reset());
        });
    }

    private void loopDirInsertToSet(File parent, Set<String> pathSet) {
        if (!parent.isDirectory()) {
            return;
        }
        pathSet.add(parent.getPath());
        for (File child : Objects.requireNonNull(parent.listFiles())) {
            this.loopDirInsertToSet(child, pathSet);
        }
    }
}

