/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.trace;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StaticFieldLookUp<T> {
    private final Class<?> targetClazz;
    private final Class<T> findClazz;

    public StaticFieldLookUp(Class<?> targetClazz, Class<T> findClazz) {
        this.targetClazz = Objects.requireNonNull(targetClazz, "targetClazz");
        this.findClazz = Objects.requireNonNull(findClazz, "findClazz");
    }

    public List<T> lookup(Filter<T> filter) {
        Field[] declaredFields;
        Objects.requireNonNull(filter, "filter");
        ArrayList<T> lookup = new ArrayList<T>();
        for (Field field : declaredFields = this.targetClazz.getDeclaredFields()) {
            T type;
            Object filedObject;
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !field.getType().equals(this.findClazz) || !this.findClazz.isInstance(filedObject = this.getObject(field)) || filter.filter(type = this.findClazz.cast(filedObject))) continue;
            lookup.add(type);
        }
        return lookup;
    }

    public List<T> lookup() {
        return this.lookup(new BypassFilter());
    }

    private Object getObject(Field field) {
        try {
            return field.get(this.findClazz);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("service access fail. Caused by:" + ex.getMessage(), ex);
        }
    }

    public static class ExcludeFilter<T>
    implements Filter<T> {
        private final T[] excludeTypeList;

        public ExcludeFilter(T[] excludeTypeList) {
            this.excludeTypeList = Objects.requireNonNull(excludeTypeList, "excludeTypeList");
        }

        @Override
        public boolean filter(T type) {
            for (T excludeType : this.excludeTypeList) {
                if (excludeType != type) continue;
                return true;
            }
            return false;
        }
    }

    public static class BypassFilter<T>
    implements Filter<T> {
        @Override
        public boolean filter(T type) {
            return false;
        }
    }

    public static interface Filter<T> {
        public static final boolean FILTERED = true;
        public static final boolean INCLUDE = false;

        public boolean filter(T var1);
    }
}

