/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.util;

import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientFactoryUtils {
    private static final Logger LOGGER = LogManager.getLogger(ClientFactoryUtils.class);

    public static PinpointClientProvider newPinpointClientProvider(String host, int port, PinpointClientFactory clientFactory) {
        return new DnsPinpointClientProvider(host, port, clientFactory);
    }

    public static PinpointClient createPinpointClient(String host, int port, PinpointClientFactory clientFactory) {
        PinpointClient pinpointClient = null;
        for (int i = 0; i < 3; ++i) {
            try {
                pinpointClient = clientFactory.connect(host, port);
                LOGGER.info("tcp connect success. remote:{}/{}", (Object)host, (Object)port);
                return pinpointClient;
            }
            catch (PinpointSocketException e) {
                LOGGER.warn("tcp connect fail. remote:{}/{} try reconnect, retryCount:{}", (Object)host, (Object)port, (Object)i);
                continue;
            }
        }
        LOGGER.warn("change background tcp connect mode remote:{}/{} ", (Object)host, (Object)port);
        pinpointClient = clientFactory.scheduledConnect(host, port);
        return pinpointClient;
    }

    public static PinpointClient createPinpointClient(SocketAddressProvider addressProvider, PinpointClientFactory clientFactory) {
        PinpointClient pinpointClient = null;
        for (int i = 0; i < 3; ++i) {
            try {
                pinpointClient = clientFactory.connect(addressProvider);
                LOGGER.info("tcp connect success. remote:{}", (Object)pinpointClient.getRemoteAddress());
                return pinpointClient;
            }
            catch (PinpointSocketException e) {
                LOGGER.warn("tcp connect fail. remote:{} try reconnect, retryCount:{}", (Object)addressProvider, (Object)i);
                continue;
            }
        }
        LOGGER.warn("change background tcp connect mode remote:{} ", (Object)addressProvider);
        pinpointClient = clientFactory.scheduledConnect(addressProvider);
        return pinpointClient;
    }

    private static class DnsPinpointClientProvider
    implements PinpointClientProvider {
        private final PinpointClientFactory clientFactory;
        private final String host;
        private final int port;

        public DnsPinpointClientProvider(String host, int port, PinpointClientFactory clientFactory) {
            this.host = Objects.requireNonNull(host, "host");
            this.port = port;
            this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
        }

        @Override
        public String getAddressAsString() {
            return this.host + ":" + this.port;
        }

        @Override
        public PinpointClient get() {
            return ClientFactoryUtils.createPinpointClient(this.host, this.port, this.clientFactory);
        }
    }

    public static interface PinpointClientProvider {
        public PinpointClient get();

        public String getAddressAsString();
    }
}

