/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.stream.StreamChannel;
import com.navercorp.pinpoint.rpc.stream.StreamException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StreamChannelRepository {
    private final ConcurrentMap<Integer, StreamChannel> streamChannelMap = new ConcurrentHashMap<Integer, StreamChannel>();

    public void registerIfAbsent(StreamChannel streamChannel) throws StreamException {
        Objects.requireNonNull(streamChannel, "streamChannel");
        int streamId = streamChannel.getStreamId();
        if (this.streamChannelMap.putIfAbsent(streamId, streamChannel) != null) {
            throw new StreamException(StreamCode.ID_DUPLICATED);
        }
    }

    public StreamChannel unregister(StreamChannel streamChannel) {
        Objects.requireNonNull(streamChannel, "streamChannel");
        return this.unregister(streamChannel.getStreamId());
    }

    public StreamChannel unregister(int streamId) {
        return (StreamChannel)this.streamChannelMap.remove(streamId);
    }

    public StreamChannel getStreamChannel(int channelId) {
        return (StreamChannel)this.streamChannelMap.get(channelId);
    }

    public int size() {
        return this.streamChannelMap.size();
    }

    public void close(StreamCode closeCode) {
        Set streamIdSet = this.streamChannelMap.keySet();
        for (Integer streamId : streamIdSet) {
            StreamChannel unregisteredStreamChannel = this.unregister(streamId);
            if (unregisteredStreamChannel == null) continue;
            unregisteredStreamChannel.close(closeCode);
        }
    }
}

