/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class PayloadPacket {
    private static final Logger logger = LogManager.getLogger(PayloadPacket.class);
    private static final ChannelBuffer EMPTY_BUFFER = ChannelBuffers.buffer((int)0);

    public static ChannelBuffer readPayload(ChannelBuffer buffer) {
        if (buffer.readableBytes() < 4) {
            buffer.resetReaderIndex();
            return null;
        }
        int payloadLength = buffer.readInt();
        if (payloadLength <= 0) {
            return EMPTY_BUFFER;
        }
        if (buffer.readableBytes() < payloadLength) {
            buffer.resetReaderIndex();
            return null;
        }
        return buffer.readBytes(payloadLength);
    }

    public static ChannelBuffer appendPayload(ChannelBuffer header, byte[] payload) {
        if (payload == null) {
            header.writeInt(-1);
            return header;
        }
        header.writeInt(payload.length);
        ChannelBuffer payloadWrap = ChannelBuffers.wrappedBuffer((byte[])payload);
        return ChannelBuffers.wrappedBuffer((boolean)true, (ChannelBuffer[])new ChannelBuffer[]{header, payloadWrap});
    }
}

