/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.ChannelWriteFailListenableFuture;
import com.navercorp.pinpoint.rpc.DefaultFuture;
import com.navercorp.pinpoint.rpc.FailureEventHandler;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.ResponsePacket;
import com.navercorp.pinpoint.rpc.server.PinpointServer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class RequestManager {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final AtomicInteger requestId = new AtomicInteger(1);
    private final ConcurrentMap<Integer, DefaultFuture<ResponseMessage>> requestMap = new ConcurrentHashMap<Integer, DefaultFuture<ResponseMessage>>();
    private final Timer timer;
    private final long defaultTimeoutMillis;

    public RequestManager(Timer timer, long defaultTimeoutMillis) {
        this.timer = Objects.requireNonNull(timer, "timer");
        if (defaultTimeoutMillis <= 0L) {
            throw new IllegalArgumentException("defaultTimeoutMillis must greater than zero.");
        }
        this.defaultTimeoutMillis = defaultTimeoutMillis;
    }

    private FailureEventHandler createFailureEventHandler(final int requestId) {
        FailureEventHandler failureEventHandler = new FailureEventHandler(){

            @Override
            public boolean fireFailure() {
                DefaultFuture<ResponseMessage> future = RequestManager.this.removeMessageFuture(requestId);
                return future != null;
            }
        };
        return failureEventHandler;
    }

    private void addTimeoutTask(DefaultFuture future, long timeoutMillis) {
        Objects.requireNonNull(future, "future");
        try {
            Timeout timeout = this.timer.newTimeout((TimerTask)future, timeoutMillis, TimeUnit.MILLISECONDS);
            future.setTimeout(timeout);
        }
        catch (IllegalStateException e) {
            future.setFailure(new PinpointSocketException("socket closed"));
        }
    }

    public int nextRequestId() {
        return this.requestId.getAndIncrement();
    }

    public void messageReceived(ResponsePacket responsePacket, String objectUniqName) {
        int requestId = responsePacket.getRequestId();
        DefaultFuture<ResponseMessage> future = this.removeMessageFuture(requestId);
        if (future == null) {
            this.logger.warn("future not found:{}, objectUniqName:{}", (Object)responsePacket, (Object)objectUniqName);
            return;
        }
        this.logger.debug("responsePacket arrived packet:{}, objectUniqName:{}", (Object)responsePacket, (Object)objectUniqName);
        ResponseMessage response = new ResponseMessage();
        response.setMessage(responsePacket.getPayload());
        future.setResult(response);
    }

    public void messageReceived(ResponsePacket responsePacket, PinpointServer pinpointServer) {
        int requestId = responsePacket.getRequestId();
        DefaultFuture<ResponseMessage> future = this.removeMessageFuture(requestId);
        if (future == null) {
            this.logger.warn("future not found:{}, pinpointServer:{}", (Object)responsePacket, (Object)pinpointServer);
            return;
        }
        this.logger.debug("responsePacket arrived packet:{}, pinpointServer:{}", (Object)responsePacket, (Object)pinpointServer);
        ResponseMessage response = new ResponseMessage();
        response.setMessage(responsePacket.getPayload());
        future.setResult(response);
    }

    public DefaultFuture<ResponseMessage> removeMessageFuture(int requestId) {
        return (DefaultFuture)this.requestMap.remove(requestId);
    }

    public void messageReceived(RequestPacket requestPacket, Channel channel) {
        this.logger.error("unexpectedMessage received:{} address:{}", (Object)requestPacket, (Object)channel.getRemoteAddress());
    }

    public ChannelWriteFailListenableFuture<ResponseMessage> register(int requestId) {
        return this.register(requestId, this.defaultTimeoutMillis);
    }

    public ChannelWriteFailListenableFuture<ResponseMessage> register(int requestId, long timeoutMillis) {
        ChannelWriteFailListenableFuture<ResponseMessage> responseFuture = new ChannelWriteFailListenableFuture<ResponseMessage>(timeoutMillis);
        DefaultFuture old = this.requestMap.put(requestId, responseFuture);
        if (old != null) {
            throw new PinpointSocketException("unexpected error. old future exist:" + old + " id:" + requestId);
        }
        FailureEventHandler removeTable = this.createFailureEventHandler(requestId);
        responseFuture.setFailureEventHandler(removeTable);
        this.addTimeoutTask(responseFuture, timeoutMillis);
        return responseFuture;
    }

    public void close() {
        this.logger.debug("close()");
        PinpointSocketException closed = new PinpointSocketException("socket closed");
        int requestFailCount = 0;
        for (Map.Entry entry : this.requestMap.entrySet()) {
            if (!((DefaultFuture)entry.getValue()).setFailure(closed)) continue;
            ++requestFailCount;
        }
        this.requestMap.clear();
        if (requestFailCount > 0) {
            this.logger.info("requestManager failCount:{}", (Object)requestFailCount);
        }
    }
}

