/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.client.tables.BadKeyVersionException;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.client.tables.Put;
import io.pravega.client.tables.Remove;
import io.pravega.client.tables.TableEntry;
import io.pravega.client.tables.TableEntryUpdate;
import io.pravega.client.tables.TableKey;
import io.pravega.client.tables.Version;
import io.pravega.client.tables.impl.SegmentSelector;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.client.tables.impl.TableSegmentKey;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import io.pravega.client.tables.impl.VersionImpl;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import lombok.Generated;
import lombok.NonNull;

class TableEntryHelper {
    private final SegmentSelector selector;
    private final KeyValueTableConfiguration config;
    private final int totalKeyLength;

    TableEntryHelper(@NonNull SegmentSelector selector, @NonNull KeyValueTableConfiguration config) {
        if (selector == null) {
            throw new NullPointerException("selector is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.selector = selector;
        this.config = config;
        this.totalKeyLength = this.config.getTotalKeyLength();
    }

    TableSegmentKey toTableSegmentKey(TableSegment tableSegment, Remove removal) {
        this.validateKeyVersionSegment(tableSegment, removal.getVersion());
        return this.toTableSegmentKey(this.serializeKey(removal.getKey()), removal.getVersion());
    }

    private TableSegmentKey toTableSegmentKey(ByteBuf key, Version keyVersion) {
        return new TableSegmentKey(key, this.toTableSegmentVersion(keyVersion));
    }

    TableKey fromTableSegmentKey(TableSegmentKey key) {
        DeserializedKey rawKey = this.deserializeKey(key.getKey());
        return new TableKey(rawKey.primaryKey, rawKey.secondaryKey);
    }

    TableSegmentEntry toTableSegmentEntry(TableSegment tableSegment, TableEntryUpdate update) {
        TableKey key = update.getKey();
        if (update instanceof Put) {
            this.validateKeyVersionSegment(tableSegment, update.getVersion());
        }
        return new TableSegmentEntry(this.toTableSegmentKey(this.serializeKey(key), update.getVersion()), this.serializeValue(update.getValue()));
    }

    TableEntry fromTableSegmentEntry(TableSegment s, TableSegmentEntry e) {
        if (e == null) {
            return null;
        }
        VersionImpl version = new VersionImpl(s.getSegmentId(), e.getKey().getVersion());
        TableKey key = this.fromTableSegmentKey(e.getKey());
        ByteBuffer value = this.deserializeValue(e.getValue());
        return new TableEntry(key, version, value);
    }

    private TableSegmentKeyVersion toTableSegmentVersion(Version version) {
        return version == null ? TableSegmentKeyVersion.NO_VERSION : TableSegmentKeyVersion.from(version.asImpl().getSegmentVersion());
    }

    ByteBuf serializeKey(TableKey k) {
        return this.serializeKey(k.getPrimaryKey(), k.getSecondaryKey());
    }

    ByteBuf serializeKey(ByteBuffer primaryKey, ByteBuffer secondaryKey) {
        Preconditions.checkArgument((primaryKey.remaining() == this.config.getPrimaryKeyLength() ? 1 : 0) != 0, (String)"Invalid Primary Key Length. Expected %s, actual %s.", (int)this.config.getPrimaryKeyLength(), (int)primaryKey.remaining());
        if (this.config.getSecondaryKeyLength() == 0) {
            Preconditions.checkArgument((secondaryKey == null || secondaryKey.remaining() == this.config.getSecondaryKeyLength() ? 1 : 0) != 0, (Object)"Not expecting a Secondary Key.");
            return Unpooled.wrappedBuffer((ByteBuffer)primaryKey);
        }
        Preconditions.checkArgument((secondaryKey.remaining() == this.config.getSecondaryKeyLength() ? 1 : 0) != 0, (String)"Invalid Secondary Key Length. Expected %s, actual %s.", (int)this.config.getSecondaryKeyLength(), (int)secondaryKey.remaining());
        return Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{primaryKey, secondaryKey});
    }

    private DeserializedKey deserializeKey(ByteBuf keySerialization) {
        Preconditions.checkArgument((keySerialization.readableBytes() == this.totalKeyLength ? 1 : 0) != 0, (String)"Unexpected key length read back. Expected %s, found %s.", (int)this.totalKeyLength, (int)keySerialization.readableBytes());
        ByteBuffer pk = keySerialization.slice(0, this.config.getPrimaryKeyLength()).copy().nioBuffer();
        ByteBuffer sk = keySerialization.slice(this.config.getPrimaryKeyLength(), this.config.getSecondaryKeyLength()).copy().nioBuffer();
        keySerialization.release();
        return new DeserializedKey(pk, sk);
    }

    private ByteBuf serializeValue(ByteBuffer v) {
        Preconditions.checkArgument((v.remaining() <= 1040384 ? 1 : 0) != 0, (String)"Value Too Long. Expected at most %s, actual %s.", (int)1040384, (int)v.remaining());
        return Unpooled.wrappedBuffer((ByteBuffer)v);
    }

    private ByteBuffer deserializeValue(ByteBuf s) {
        ByteBuffer result = s.copy().nioBuffer();
        s.release();
        return result;
    }

    private void validateKeyVersionSegment(TableSegment ts, Version version) {
        boolean valid;
        if (version == null) {
            return;
        }
        VersionImpl impl = version.asImpl();
        boolean bl = valid = impl.getSegmentId() == Long.MIN_VALUE || ts.getSegmentId() == impl.getSegmentId();
        if (!valid) {
            throw new BadKeyVersionException(this.selector.getKvt().getScopedName(), "Wrong TableSegment.");
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentSelector getSelector() {
        return this.selector;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyValueTableConfiguration getConfig() {
        return this.config;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getTotalKeyLength() {
        return this.totalKeyLength;
    }

    private static class DeserializedKey {
        final ByteBuffer primaryKey;
        final ByteBuffer secondaryKey;

        @ConstructorProperties(value={"primaryKey", "secondaryKey"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeserializedKey(ByteBuffer primaryKey, ByteBuffer secondaryKey) {
            this.primaryKey = primaryKey;
            this.secondaryKey = secondaryKey;
        }
    }
}

