/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import io.pravega.client.ClientConfig;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.stream.EventStreamReader;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.ReaderConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.TransactionalEventStreamWriter;
import io.pravega.client.stream.impl.ClientFactoryImpl;

public interface EventStreamClientFactory
extends AutoCloseable {
    public static EventStreamClientFactory withScope(String scope, ClientConfig config) {
        SocketConnectionFactoryImpl connectionFactory = new SocketConnectionFactoryImpl(config);
        return new ClientFactoryImpl(scope, (Controller)new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor()), connectionFactory);
    }

    public <T> EventStreamWriter<T> createEventWriter(String var1, Serializer<T> var2, EventWriterConfig var3);

    public <T> EventStreamWriter<T> createEventWriter(String var1, String var2, Serializer<T> var3, EventWriterConfig var4);

    public <T> TransactionalEventStreamWriter<T> createTransactionalEventWriter(String var1, String var2, Serializer<T> var3, EventWriterConfig var4);

    public <T> TransactionalEventStreamWriter<T> createTransactionalEventWriter(String var1, Serializer<T> var2, EventWriterConfig var3);

    public <T> EventStreamReader<T> createReader(String var1, String var2, Serializer<T> var3, ReaderConfig var4);

    @Override
    public void close();
}

