/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import java.sql.SQLException;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.EmpireException;

public class EmpireSQLException
extends EmpireException {
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.db.sqlException", "The database operation failed. Native error is: {0}");
    private final String nativeErrorMessage;

    protected static String messageFromSQLException(DBMSHandler dbms, SQLException sqle) {
        return dbms != null ? dbms.extractErrorMessage(sqle) : sqle.getMessage();
    }

    protected static DBMSHandler handlerFromObject(DBObject obj) {
        return obj.getDatabase() != null ? ((DBDatabase)obj.getDatabase()).getDbms() : (DBMSHandler)null;
    }

    public EmpireSQLException(DBMSHandler dbms, SQLException cause) {
        super(errorType, new String[]{EmpireSQLException.messageFromSQLException(dbms, cause)}, cause);
        this.nativeErrorMessage = this.getErrorParams()[0];
    }

    public EmpireSQLException(DBObject obj, SQLException cause) {
        this(EmpireSQLException.handlerFromObject(obj), cause);
    }

    protected EmpireSQLException(ErrorType type, String[] params, int nativeErrorIndex, SQLException cause) {
        super(type, params, cause);
        this.nativeErrorMessage = this.getErrorParams()[nativeErrorIndex];
    }

    public String getNativeErrorMessage() {
        return this.nativeErrorMessage;
    }
}

