/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.jsf2.utils.StyleClass;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleTag
extends UIOutput
implements TagEncodingHelperFactory.TagEncodingHolder {
    private static final Logger log = LoggerFactory.getLogger(TitleTag.class);
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.TITLE.get());

    public TitleTag() {
        log.trace("component LabelTag created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    @Override
    public TagEncodingHelper getEncodingHelper() {
        return this.helper;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        Column column = this.helper.getColumn();
        if (column == null) {
            throw new InvalidArgumentException("column", (Object)column);
        }
        String title = this.helper.getLabelTooltip(column);
        ResponseWriter writer = context.getResponseWriter();
        String tag = this.writeStartElement(title, writer);
        this.renderTitle(column, writer);
        if (tag != null) {
            writer.endElement(tag);
        }
    }

    protected void renderTitle(Column column, ResponseWriter writer) throws IOException {
        String title = StringUtils.toString((Object)this.getValue());
        if (this.helper.hasFormat("short") && (title = StringUtils.toString((Object)column.getAttribute("ABBR_TITLE"))) == null) {
            log.warn("No Abbreviation available for column {}. Using normal title.", (Object)column.getName());
        }
        if (title == null) {
            title = column.getTitle();
        }
        writer.append((CharSequence)(StringUtils.isEmpty((String)(title = this.helper.getDisplayText(title))) ? "&nbsp;" : title));
    }

    protected String writeStartElement(String title, ResponseWriter writer) throws IOException {
        Map map = this.getAttributes();
        String tag = StringUtils.toString(map.get("tag"));
        if (tag == null && title == null && !map.containsKey("styleClass")) {
            return null;
        }
        if (StringUtils.isEmpty((String)tag)) {
            tag = "span";
        }
        StyleClass styleClass = this.helper.getTagStyleClass(null);
        writer.startElement(tag, (UIComponent)this);
        this.helper.writeAttribute(writer, "class", styleClass);
        this.helper.writeAttribute(writer, "style", map.get("style"));
        this.helper.writeAttribute(writer, "title", title);
        return tag;
    }
}

