/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutcomeTargetLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.components.LinkTag;
import org.apache.empire.jsf2.components.MenuListTag;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuItemTag
extends LinkTag {
    private static final Logger log = LoggerFactory.getLogger(MenuItemTag.class);
    protected MenuListTag parentMenu;
    protected String menuId;

    @Override
    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    @Override
    public void setId(String id) {
        if (id.endsWith("@")) {
            this.menuId = this.helper.getTagAttributeString("menuId");
            if (StringUtils.isNotEmpty((String)this.menuId)) {
                int idx = id.indexOf(64);
                String ident = idx > 0 ? id.substring(0, idx) + this.menuId : this.menuId;
                id = TagEncodingHelper.buildComponentId(ident);
            }
        }
        super.setId(id);
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        String wrap;
        this.parentMenu = this.findParentMenu();
        if (this.menuId == null) {
            this.menuId = this.helper.getTagAttributeString("menuId");
        }
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", (UIComponent)this);
        this.helper.writeComponentId(writer);
        this.helper.writeAttribute(writer, "class", this.getStyleClass());
        String string = wrap = this.parentMenu != null ? this.parentMenu.getItemWrapperTagName() : null;
        if (StringUtils.isNotEmpty((String)wrap)) {
            writer.startElement(wrap, (UIComponent)this);
        }
        super.encodeBegin(context);
        if (StringUtils.isNotEmpty((String)wrap)) {
            writer.endElement(wrap);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isExpanded()) {
            UIComponent c = (UIComponent)this.getChildren().get(0);
            if (c instanceof HtmlOutcomeTargetLink) {
                if (c.isRendered()) {
                    log.warn("WARN: Unexpected rendering of output link. Rendering is ignored.");
                    c.setRendered(false);
                }
            } else {
                log.warn("WARN: Unexpected child element as first child of MenuItemTag!");
            }
            super.forceEncodeChildren(context);
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this.isExpanded()) {
            super.encodeEnd(context);
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("li");
    }

    @Override
    protected String getLinkStyleClass() {
        Object linkStyle = this.getAttributes().get("linkStyle");
        return linkStyle != null ? linkStyle.toString() : null;
    }

    protected MenuListTag findParentMenu() {
        MenuItemTag parent = this;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof MenuListTag)) continue;
            return (MenuListTag)((Object)parent);
        }
        return null;
    }

    protected boolean isCurrent() {
        if (this.menuId == null || this.parentMenu == null || this.parentMenu.getCurrentItemId() == null) {
            return false;
        }
        return this.menuId.equals(this.parentMenu.getCurrentItemId());
    }

    protected boolean isParent() {
        if (this.menuId == null || this.parentMenu == null || this.parentMenu.getCurrentItemId() == null) {
            return false;
        }
        String currentId = this.parentMenu.getCurrentItemId();
        return currentId.length() > this.menuId.length() && currentId.startsWith(this.menuId);
    }

    protected boolean isDisabled() {
        Object value = this.helper.getTagAttributeValue("disabled");
        if (value != null) {
            return ObjectUtils.getBoolean((Object)value);
        }
        return false;
    }

    protected boolean isExpanded() {
        Object value = this.helper.getTagAttributeValue("expanded");
        boolean auto = false;
        if (value != null) {
            auto = "auto".equals(value);
            if (!auto) {
                return ObjectUtils.getBoolean((Object)value);
            }
            if (this.isCurrent()) {
                return true;
            }
        }
        if (this.menuId == null || this.parentMenu == null || this.parentMenu.getCurrentItemId() == null) {
            return auto;
        }
        String currentId = this.parentMenu.getCurrentItemId();
        return currentId.startsWith(this.menuId + ".");
    }

    public boolean isRendered() {
        Object value = this.helper.getTagAttributeValue("currentOnly");
        boolean currentOnly = false;
        if (value != null) {
            currentOnly = ObjectUtils.getBoolean((Object)value);
        }
        if (currentOnly && this.menuId != null && this.parentMenu != null && this.parentMenu.getCurrentItemId() != null) {
            return this.isCurrent() || this.isParent();
        }
        return super.isRendered();
    }

    protected String getStyleClass() {
        String styleClass = this.helper.getTagAttributeString("styleClass");
        if (this.parentMenu != null) {
            if (StringUtils.isEmpty((String)styleClass)) {
                styleClass = this.parentMenu.getItemStyleClass();
            }
            if (this.isCurrent()) {
                styleClass = this.appendStyleClass(styleClass, this.parentMenu.getCurrentItemClass());
            } else if (this.isParent()) {
                styleClass = this.appendStyleClass(styleClass, this.parentMenu.getParentItemClass());
            }
            if (this.isExpanded()) {
                styleClass = this.appendStyleClass(styleClass, this.parentMenu.getItemExpandedClass());
            }
            if (this.isDisabled()) {
                styleClass = this.appendStyleClass(styleClass, this.parentMenu.getItemDisabledClass());
            }
        } else if (this.isDisabled()) {
            styleClass = this.appendStyleClass(styleClass, "disabled");
        }
        return styleClass;
    }

    protected String appendStyleClass(String styleClass, String newClass) {
        if (StringUtils.isEmpty((String)newClass)) {
            return styleClass;
        }
        return styleClass == null ? newClass : styleClass + " " + newClass;
    }

    @Override
    protected boolean isEncodeLinkChildren(Object linkValue) {
        return false;
    }

    @Override
    protected void encodeLinkComponent(FacesContext context, HtmlOutcomeTargetLink linkComponent) throws IOException {
        UIComponent labelFacet = this.getFacet("label");
        if (labelFacet != null) {
            linkComponent.encodeBegin(context);
            labelFacet.encodeAll(context);
            linkComponent.encodeEnd(context);
        } else {
            linkComponent.encodeAll(context);
        }
    }
}

