/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.oracle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDataDictionnary {
    protected static final Logger log = LoggerFactory.getLogger(OracleDataDictionnary.class);
    private final HashMap<String, HashMap<String, ColumnInfo>> dictionnary = new HashMap();
    private Map<String, DataType[]> dataTypeMapping = new HashMap<String, DataType[]>();

    public OracleDataDictionnary() {
        this.dataTypeMapping.put("VARCHAR2", new DataType[]{DataType.VARCHAR});
        this.dataTypeMapping.put("CHAR", new DataType[]{DataType.CHAR, DataType.BOOL});
        this.dataTypeMapping.put("NUMBER", new DataType[]{DataType.DECIMAL, DataType.FLOAT, DataType.INTEGER, DataType.AUTOINC, DataType.BOOL});
        this.dataTypeMapping.put("DATE", new DataType[]{DataType.DATE, DataType.DATETIME});
        this.dataTypeMapping.put("TIMESTAMP", new DataType[]{DataType.TIMESTAMP});
        this.dataTypeMapping.put("CLOB", new DataType[]{DataType.CLOB});
        this.dataTypeMapping.put("BLOB", new DataType[]{DataType.BLOB});
    }

    public HashMap<String, HashMap<String, ColumnInfo>> getDictionnary() {
        return this.dictionnary;
    }

    public void fillDataDictionnary(String tableName, String columnName, String dataType, int charLength, int dataLength, int dataPrecision, int dataScale, String nullable) {
        ColumnInfo colInfo = new ColumnInfo(dataType, charLength, dataLength, dataPrecision, dataScale, nullable);
        HashMap<String, ColumnInfo> columns = new HashMap<String, ColumnInfo>();
        if (this.dictionnary.containsKey(tableName)) {
            columns = this.dictionnary.get(tableName);
        }
        columns.put(columnName, colInfo);
        this.dictionnary.put(tableName, columns);
    }

    private boolean checkMapping(String dbDatatype, DataType colDataType) {
        DataType[] colTypes = this.dataTypeMapping.get(dbDatatype);
        if (colTypes == null) {
            log.warn("MAPPING NOT DEFINED FOR " + dbDatatype + " -> " + (Object)((Object)colDataType));
            return false;
        }
        for (int i = 0; i < colTypes.length; ++i) {
            if (colTypes[i] != colDataType) continue;
            return true;
        }
        return false;
    }

    private void checkColumn(DBColumn column, ColumnInfo colInfo) {
        if (!this.checkMapping(colInfo.getDataType(), column.getDataType())) {
            log.warn("WRONG DATA TYPE: \t" + column.getFullName() + " is set to " + (Object)((Object)column.getDataType()) + " instead of " + colInfo.getDataType());
        }
        if (colInfo.getDataType().equals("VARCHAR2") && column.getSize() != (double)colInfo.getCharLength()) {
            log.warn("WRONG COLUMN SIZE: \t" + column.getFullName() + " is set to " + (int)column.getSize() + " instead of " + colInfo.getCharLength());
        }
        if (column.isRequired() != colInfo.getNullable().equals("N")) {
            log.warn("WRONG NULLABLE FLAG: \t" + column.getFullName() + " is set to " + column.isRequired() + " instead of " + colInfo.getNullable().equals("N"));
        }
    }

    public void checkDBTableDefinition(List<DBTable> dbTables) {
        for (DBTable currentTable : dbTables) {
            String dbTableName = currentTable.getName();
            if (this.dictionnary.containsKey(dbTableName)) {
                for (DBColumn currentColumn : currentTable.getColumns()) {
                    Set<String> dictColumns = this.dictionnary.get(dbTableName).keySet();
                    if (dictColumns.contains(currentColumn.getName())) {
                        for (String dictColumn : dictColumns) {
                            if (!currentColumn.getName().equals(dictColumn)) continue;
                            ColumnInfo colInfo = this.dictionnary.get(currentTable.getName()).get(dictColumn);
                            this.checkColumn(currentColumn, colInfo);
                        }
                        continue;
                    }
                    log.warn("MISSING COLUMN: \t" + currentColumn.getFullName() + " does not exist in database");
                }
                continue;
            }
            log.warn("MISSING TABLE: \t" + currentTable.getName() + " does not exist in database");
        }
    }

    public void checkDBViewDefinition(List<DBView> dbViews) {
        for (DBView currentView : dbViews) {
            String dbviewName = currentView.getName();
            if (this.dictionnary.containsKey(dbviewName)) {
                for (DBColumn currentColumn : currentView.getColumns()) {
                    Set<String> dictColumns = this.dictionnary.get(dbviewName).keySet();
                    if (dictColumns.contains(currentColumn.getName())) {
                        for (String dictColumn : dictColumns) {
                            ColumnInfo colInfo;
                            if (!currentColumn.getName().equals(dictColumn) || this.checkMapping((colInfo = this.dictionnary.get(currentView.getName()).get(dictColumn)).getDataType(), currentColumn.getDataType())) continue;
                            log.warn("WRONG DATA TYPE: \t" + currentColumn.getFullName() + " is set to " + (Object)((Object)currentColumn.getDataType()) + " instead of " + colInfo.getDataType());
                        }
                        continue;
                    }
                    log.warn("MISSING COLUMN: \t" + currentColumn.getFullName() + " does not exist in database.");
                }
                continue;
            }
            log.warn("MISSING VIEW: \t" + currentView.getName() + " does not exist in database.");
        }
    }

    public class ColumnInfo {
        private final String dataType;
        private final int charLength;
        private final int dataLength;
        private final int dataPrecision;
        private final int dataScale;
        private final String nullable;

        public ColumnInfo(String dataType, int charLength, int dataLength, int dataPrecision, int dataScale, String nullable) {
            this.dataType = dataType;
            this.charLength = charLength;
            this.dataLength = dataLength;
            this.dataPrecision = dataPrecision;
            this.dataScale = dataScale;
            this.nullable = nullable;
        }

        public int getCharLength() {
            return this.charLength;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public int getDataPrecision() {
            return this.dataPrecision;
        }

        public int getDataScale() {
            return this.dataScale;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getNullable() {
            return this.nullable;
        }
    }
}

