/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.oracle;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.validation.DBModelChecker;
import org.apache.empire.db.validation.DBModelErrorHandler;
import org.apache.empire.dbms.oracle.DBMSHandlerOracle;
import org.apache.empire.dbms.oracle.OracleDBModelParser;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDBModelChecker
extends DBModelChecker {
    private static final Logger log = LoggerFactory.getLogger(OracleDBModelChecker.class);
    private final DBMSHandlerOracle.BooleanType booleanType;

    public OracleDBModelChecker(OracleDBModelParser modelParser, DBMSHandlerOracle.BooleanType booleanType) {
        super(modelParser);
        this.booleanType = booleanType;
        log.info("OracleDBModelChecker created for {} with booleanType {}", (Object)modelParser.getSchemaName(), (Object)booleanType);
    }

    @Override
    protected void checkBoolColumn(DBColumn column, DBColumn remoteColumn, DBModelErrorHandler handler) {
        this.checkColumnNullable(column, remoteColumn, handler);
        DataType booleanDataType = null;
        switch (this.booleanType) {
            case NUMBER: {
                booleanDataType = DataType.DECIMAL;
                break;
            }
            case CHAR: {
                booleanDataType = DataType.CHAR;
                break;
            }
            default: {
                throw new InvalidPropertyException("booleanType", (Object)this.booleanType);
            }
        }
        if (remoteColumn.getDataType() != booleanDataType) {
            handler.columnTypeMismatch(column, booleanDataType);
        }
        if (remoteColumn.getSize() != 1.0) {
            handler.columnSizeMismatch(column, 1, 0);
        }
    }

    @Override
    protected void checkColumnType(DBColumn column, DBColumn remoteColumn, DBModelErrorHandler handler) {
        if (column.getDataType() == DataType.INTEGER && remoteColumn.getDataType().isNumeric()) {
            return;
        }
        if (column.getDataType() == DataType.BOOL) {
            if (this.booleanType == DBMSHandlerOracle.BooleanType.CHAR) {
                if (!remoteColumn.getDataType().isText()) {
                    handler.columnTypeMismatch(column, DataType.CHAR);
                }
            } else if (!remoteColumn.getDataType().isNumeric()) {
                handler.columnTypeMismatch(column, DataType.DECIMAL);
            }
            return;
        }
        super.checkColumnType(column, remoteColumn, handler);
    }
}

