/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.context;

import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.context.DBRollbackHandler;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRollbackManager {
    private static final Logger log = LoggerFactory.getLogger(DBRollbackManager.class);
    private final Map<Integer, Map<DBObject, DBRollbackHandler>> connectionMap;
    private final int initialObjectCapacity;

    public DBRollbackManager(int initialConnectionCapacity, int initialObjectCapacity) {
        this.connectionMap = new HashMap<Integer, Map<DBObject, DBRollbackHandler>>(initialConnectionCapacity);
        this.initialObjectCapacity = initialObjectCapacity;
    }

    public synchronized void appendHandler(Connection conn, DBRollbackHandler handler) {
        DBObject object;
        if (conn == null) {
            throw new InvalidArgumentException("conn", conn);
        }
        Map<DBObject, DBRollbackHandler> handlerMap = this.connectionMap.get(conn.hashCode());
        if (handlerMap == null) {
            handlerMap = new LinkedHashMap<DBObject, DBRollbackHandler>(this.initialObjectCapacity);
            this.connectionMap.put(conn.hashCode(), handlerMap);
        }
        if ((object = handler.getObject()) == null) {
            throw new ObjectNotValidException(handler);
        }
        if (handlerMap.containsKey(object)) {
            handlerMap.get(object).combine(handler);
        } else {
            handlerMap.put(object, handler);
        }
        if (log.isDebugEnabled()) {
            log.debug("Rollback handler for {} was added.", (Object)handler.getObjectInfo());
        }
    }

    public synchronized void removeHandler(Connection conn, DBObject object) {
        if (conn == null) {
            return;
        }
        if (object == null) {
            this.releaseConnection(conn, ReleaseAction.Discard);
            return;
        }
        Map<DBObject, DBRollbackHandler> handlerMap = this.connectionMap.get(conn.hashCode());
        if (handlerMap == null) {
            return;
        }
        DBRollbackHandler handler = handlerMap.remove(object);
        if (handler == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Rollback handler for {} was removed.", (Object)handler.getObjectInfo());
        }
        handler.discard(conn);
    }

    public synchronized void releaseConnection(Connection conn, ReleaseAction action) {
        if (conn == null) {
            return;
        }
        Map<DBObject, DBRollbackHandler> handlerMap = this.connectionMap.get(conn.hashCode());
        if (handlerMap == null) {
            return;
        }
        log.info("DBRollbackManager performes {} for {} objects.", (Object)action, (Object)handlerMap.size());
        for (DBRollbackHandler handler : handlerMap.values()) {
            if (action == ReleaseAction.Rollback) {
                handler.rollback(conn);
                continue;
            }
            handler.discard(conn);
        }
        this.connectionMap.remove(conn.hashCode());
    }

    public static enum ReleaseAction {
        Discard,
        Rollback;

    }
}

