// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("window_function") {
    sql "SET enable_nereids_planner=true"

    sql "DROP TABLE IF EXISTS window_test"

    sql "DROP TABLE IF EXISTS adj_nullable_1"

    sql "DROP TABLE IF EXISTS adj_nullable_2"

    sql """
        CREATE TABLE `window_test` (
            `c1` int NULL,
            `c2` int NULL,
            `c3` double NULL
        ) ENGINE=OLAP
        DISTRIBUTED BY HASH(`c1`) BUCKETS 1
        PROPERTIES (
        "replication_allocation" = "tag.location.default: 1"
        );
    """

    sql """
        create table adj_nullable_1 (
          c1 int,
          c2 int,
          c3 int
        ) distributed by hash(c1)
        properties('replication_num'='1');
    """

    sql """
        create table adj_nullable_2 (
          c4 int not null,
          c5 int not null,
          c6 int not null
        ) distributed by hash(c4)
        properties('replication_num'='1');
    """

    sql """INSERT INTO window_test VALUES(1, 1, 1)"""
    sql """INSERT INTO window_test VALUES(1, 2, 1)"""
    sql """INSERT INTO window_test VALUES(1, 3, 1)"""
    sql """INSERT INTO window_test VALUES(2, 1, 1)"""
    sql """INSERT INTO window_test VALUES(2, 2, 1)"""
    sql """INSERT INTO window_test VALUES(2, 3, 1)"""
    sql """INSERT INTO window_test VALUES(1, 1, 2)"""
    sql """INSERT INTO window_test VALUES(1, 2, 2)"""
    sql """INSERT INTO window_test VALUES(2, 1, 2)"""
    sql """INSERT INTO window_test VALUES(2, 2, 2)"""
    sql """INSERT INTO window_test VALUES(1, 2, null)"""
    sql """INSERT INTO window_test VALUES(1, 3, null)"""
    sql """INSERT INTO window_test VALUES(1, null, 3)"""
    sql """INSERT INTO window_test VALUES(2, null, 3)"""

    sql """insert into adj_nullable_1 values(1, 1, 1);"""
    sql """insert into adj_nullable_2 values(1, 1, 1);"""

    sql "SET enable_fallback_to_original_planner=false"

    order_qt_empty_over "SELECT rank() over() FROM window_test"
    order_qt_with_star "SELECT *, rank() over(partition by c3 order by c2) FROM window_test"
    order_qt_multi_window_1 "SELECT rank() over(), row_number() over() FROM window_test"
    order_qt_multi_window_2 """
        SELECT sum(c1) over(), count(c2) over(), rank() over(partition by c3   order by c2) 
        FROM window_test
    """

    order_qt_dense_rank "SELECT dense_rank() over(partition by c3 order by c2) FROM window_test"
    order_qt_ntile "SELECT ntile(5) over(partition by c3 order by c2) FROM window_test"
    order_qt_rank "SELECT rank() over(partition by c3 order by c2) FROM window_test"
    order_qt_row_number "SELECT row_number() over(partition by c3 order by c2) FROM window_test"
    order_qt_sum "SELECT sum(c1) over(partition by c3 order by c2) FROM window_test"
    order_qt_avg "SELECT avg(c1) over(partition by c3 order by c2) FROM window_test"
    order_qt_count "SELECT count(c1) over(partition by c3 order by c2) FROM window_test"
    sql "SELECT first_value(c1) over(partition by c3 order by c2) FROM window_test"
    sql "SELECT last_value(c1) over(partition by c3 order by c2) FROM window_test"
    sql "SELECT lead(c1, 1, 111) over(partition by c3 order by c2) FROM window_test"
    sql "SELECT lag(c1, 1, 222) over(partition by c3 order by c2) FROM window_test"
    sql "SELECT lead(c1, 3, null) over(partition by c3 order by c2) FROM window_test"
    sql "SELECT lag(c1, 2, null) over(partition by c3 order by c2) FROM window_test"
    order_qt_max "SELECT max(c1) over(partition by c3 order by c2) FROM window_test"
    order_qt_min "SELECT min(c1) over(partition by c3 order by c2) FROM window_test"

    order_qt_agg_1 """
        SELECT c1+1, c2, sum(c1), sum(c1) over(partition by c2 order by c1) 
        FROM window_test 
        GROUP BY c1, c2
    """

    order_qt_agg_2 """
        SELECT c1, c2, sum(c1+1), sum(c1+1) over(partition by c2 order by c1+1) 
        FROM window_test 
        GROUP BY c1, c2
    """

    order_qt_agg_3 """
        SELECT row_number() over(partition by (grouping(c2) + grouping(c3)))
        FROM window_test
        GROUP BY ROLLUP (c2, c3)
    """

    order_qt_subquery_1 """
        SELECT *, row_number() over(partition by c1 order by c3, c2, c1, r1) as r2
        FROM (
            SELECT *, row_number() over(partition by c2 order by c3, c2, c1) as r1
            FROM window_test
        ) t
    """

    order_qt_subquery_2 """
        SELECT * 
        FROM (   
            SELECT 
                count(1) OVER (PARTITION BY c2 ORDER BY c3) + sum(c1) OVER (PARTITION BY c2 ORDER BY c3) AS total,     
                count(1) OVER (PARTITION BY c2 ORDER BY c3) AS fourcount, 
                sum(c1) OVER (PARTITION BY c2 ORDER BY c3) AS twosum 
            FROM window_test
        ) sub 
    """

    sql """ set batch_size = 3; """
    sql """ set parallel_pipeline_task_num = 8; """

    order_qt_range """
        SELECT c1, (sum(c1) over  (ORDER BY c1 range between UNBOUNDED preceding and CURRENT ROW)) FROM window_test;
    """

    order_qt_cte """
        WITH cte as (select c1 as x from window_test) 
        SELECT x, (sum(x) over  (ORDER BY x range between UNBOUNDED preceding and CURRENT ROW)) FROM cte;
    """

    order_qt_window_use_agg """
        SELECT sum(sum(c1)) over(partition by avg(c2))
        FROM window_test
    """

    order_qt_winExpr_not_agg_expr """
        select sum(c1+1), sum(c1+1) over (partition by avg(c2))
        from window_test
        group by c1, c2
    """

    order_qt_on_notgroupbycolumn """
        select sum(sum(c3)) over (partition by avg(c2) order by c1)
        from window_test
        group by c1, c2
    """

    order_qt_orderby """
        select c1, sum(c1+1), sum(c1+1) over (partition by avg(c2) order by c1)
        from window_test
        group by c1, c2
    """

    order_qt_winExpr_with_others """
        select sum(c1)/sum(c1+1) over (partition by c2 order by c1)
        from window_test
        group by c1, c2
    """

    order_qt_winExpr_with_others2"""
        select sum(c1)/sum(c1+1) over (partition by c2 order by c1)
        from window_test
        group by c1, c2
    """

    // test adjust nullable on window
    sql """
        select 
          count(c1) over (partition by c4),
          coalesce(c5, sum(c2) over (partition by c3))
        from
          adj_nullable_1
          left join adj_nullable_2 on c1 = c4
        where c6 is not null;
    """

    // distinct with window
    sql """
        SELECT
              DISTINCT dt,
              count(dt2) over (partition by dt) as num
              from
              (select 1 as dt,2 as dt2)t
        group by dt,dt2"""

    sql """ DROP TABLE IF EXISTS table_200_undef_partitions2_keys3_properties4_distributed_by53 """
    sql """
    create table table_200_undef_partitions2_keys3_properties4_distributed_by53 (
    pk int,
    col_boolean_undef_signed boolean  null  ,
    col_boolean_undef_signed_not_null boolean  not null  ,
    col_tinyint_undef_signed tinyint  null  ,
    col_tinyint_undef_signed_not_null tinyint  not null  ,
    col_smallint_undef_signed smallint  null  ,
    col_smallint_undef_signed_not_null smallint  not null  ,
    col_int_undef_signed int  null  ,
    col_int_undef_signed_not_null int  not null  ,
    col_bigint_undef_signed bigint  null  ,
    col_bigint_undef_signed_not_null bigint  not null  ,
    col_float_undef_signed float  null  ,
    col_float_undef_signed_not_null float  not null  ,
    col_double_undef_signed double  null  ,
    col_double_undef_signed_not_null double  not null  ,
    col_decimal_10_0__undef_signed decimal(10,0)  null  ,
    col_decimal_10_0__undef_signed_not_null decimal(10,0)  not null  ,
    col_decimal_16_10__undef_signed decimal(16,10)  null  ,
    col_decimal_16_10__undef_signed_not_null decimal(16,10)  not null  ,
    col_decimal_37__12__undef_signed decimal(37, 12)  null  ,
    col_decimal_37__12__undef_signed_not_null decimal(37, 12)  not null  ,
    col_decimal_17_0__undef_signed decimal(17,0)  null  ,
    col_decimal_17_0__undef_signed_not_null decimal(17,0)  not null  ,
    col_decimal_8_4__undef_signed decimal(8,4)  null  ,
    col_decimal_8_4__undef_signed_not_null decimal(8,4)  not null  ,
    col_decimal_9_0__undef_signed decimal(9,0)  null  ,
    col_decimal_9_0__undef_signed_not_null decimal(9,0)  not null
    ) engine=olap
    UNIQUE KEY(pk)
    distributed by hash(pk) buckets 10
    properties("replication_num" = "1");
    insert into table_200_undef_partitions2_keys3_properties4_distributed_by53(pk,col_boolean_undef_signed,col_boolean_undef_signed_not_null,col_tinyint_undef_signed,col_tinyint_undef_signed_not_null,col_smallint_undef_signed,col_smallint_undef_signed_not_null,col_int_undef_signed,col_int_undef_signed_not_null,col_bigint_undef_signed,col_bigint_undef_signed_not_null,col_float_undef_signed,col_float_undef_signed_not_null,col_double_undef_signed,col_double_undef_signed_not_null,col_decimal_10_0__undef_signed,col_decimal_10_0__undef_signed_not_null,col_decimal_16_10__undef_signed,col_decimal_16_10__undef_signed_not_null,col_decimal_37__12__undef_signed,col_decimal_37__12__undef_signed_not_null,col_decimal_17_0__undef_signed,col_decimal_17_0__undef_signed_not_null,col_decimal_8_4__undef_signed,col_decimal_8_4__undef_signed_not_null,col_decimal_9_0__undef_signed,col_decimal_9_0__undef_signed_not_null) values (0,null,false,-128,0,-5521,32767,870553334,1221220826,0,7213100385307283524,77.73622,40.123,43.329228412740655,20.489504075961925,300.343,61.0185,44.1855,40.123,96.0985,40.123,100.02,300.343,null,300.343,24.0980,86.0793),(1,false,true,127,-71,10613,-2378,-2147483648,-1735831341,4688356,1,40.123,65.62778,100.02,8.156179706539959,81.0185,300.343,300.343,100.02,null,300.343,300.343,300.343,40.123,100.02,39.0762,40.123),(2,null,true,2,127,245,4267,147483648,1783793654,-5281705981187589786,245,59.17273,40.123,11.811660493368755,19.455356365825995,40.123,100.02,100.02,40.123,26.1257,49.1309,5.0953,40.123,300.343,300.343,100.02,66.0149),(3,true,true,84,-128,8528,32767,-2056120424,147483648,null,20240803,50.7821,40.123,300.343,40.00619325266508,null,38.0387,100.02,30.0539,100.02,100.02,null,52.1752,87.1266,69.0995,null,56.0744),(4,true,false,127,63,-24034,0,32679,722930907,245,-10701,300.343,100.02,93.40872726548184,71.3886552262586,300.343,28.1994,45.0914,40.123,null,100.02,null,40.123,100.02,300.343,300.343,34.0277),(5,true,true,-128,-13,null,-10170,980938523,-2028389349,300.343,1502288110756366604,73.54129,40.123,null,84.84453556483243,6.1218,67.1502,36.0493,300.343,40.123,23.0992,49.0178,74.1497,6.0665,40.123,76.0229,92.0806),(6,true,false,null,73,245,-6365,365955659,-825168545,1,32679,20.548183,39.469467,36.399472882786114,63.61718689674476,300.343,3.1746,null,29.1827,null,37.0948,300.343,52.1278,null,100.02,43.1059,40.123),(7,false,true,4,1,245,30104,-966977318,147483648,-6472164452822149829,1,99.48591,40.123,12.81888725588849,40.123,300.343,40.123,300.343,300.343,40.123,300.343,300.343,75.0332,41.1584,300.343,94.0808,100.02),(8,true,false,-128,7,-9341,0,273264246,10153427,-593,32679,null,40.123,47.5996286613163,300.343,100.02,300.343,61.1669,40.123,40.123,83.0629,6.0006,300.343,100.02,100.02,40.123,100.02),(9,true,true,-73,-127,-18853,1007,-2147483648,484409610,7571241902674251552,147483648,88.81223,90.67181,46.09140924068056,45.91107758266007,14.0974,35.0919,60.0558,100.02,null,300.343,null,84.1840,100.02,18.0133,null,4.1655),(10,false,false,69,5,0,245,-1490527072,-1493840028,-3377192489409378222,-6324580157439333282,87.16578,81.2785,300.343,45.77483384423837,18.1387,100.0525,300.343,22.0678,300.343,40.123,40.123,300.343,null,300.343,300.343,21.0889),(11,null,true,127,1,8552,8908,619538385,-1922549998,1,32679,40.123,88.807396,33.08436686203323,73.58052266548373,300.343,100.02,null,300.343,300.343,20.0532,90.1112,40.123,16.1853,100.02,100.02,300.343),(12,false,false,-106,0,0,0,32679,-843142978,300.343,300.343,18.288996,40.123,40.123,16.216679762946892,45.0787,100.02,95.1690,29.1696,100.02,300.343,45.1816,48.0997,null,97.0816,79.0883,83.1233),(13,null,true,1,68,0,-6288,26755852,2147483647,8178343,1,40.123,52.127373,40.123,40.606420235269525,2.1082,100.0243,40.123,26.1287,100.02,53.0670,40.123,100.02,null,300.343,81.1487,40.123),(14,true,false,-128,1,0,-7988,-1877117050,1882515617,147483648,-16312,87.14053,300.343,34.137315647747215,18.4177490944626,16.0717,40.123,100.02,92.1450,100.02,100.02,40.123,61.0075,53.1299,2.0102,87.0173,77.1927),(15,null,true,-128,1,20309,245,-249173211,-661830642,0,300.343,31.596346,17.814812,1.8288288462895608,100.02,40.123,100.02,40.123,40.123,100.02,300.343,40.123,300.343,40.123,73.0959,null,58.1723),(16,null,true,-28,2,32767,4998,147483648,32679,300.343,7,8.024016,19.004923,95.10220072797654,300.343,null,15.0435,12.1656,35.0773,19.1281,70.1733,82.1688,60.0645,69.1016,300.343,300.343,36.0207),(17,null,false,-128,-125,20665,-1816,null,-2147483648,300.343,20240803,100.02,15.448185,16.059618185812642,40.123,300.343,84.0546,300.343,40.123,300.343,100.02,300.343,24.1521,87.0186,100.02,100.02,86.0008),(18,false,false,127,0,-32768,245,709619843,-1187168694,1,245,26.72707,14.693371,51.950037154435954,100.02,61.0306,34.0408,26.1877,300.343,300.343,40.123,300.343,300.343,52.0132,100.02,68.0395,300.343),(19,null,true,127,7,-4902,-1992,2049362398,2147483647,20240803,1,40.123,92.96219,95.76594950639095,40.123,25.1403,85.1143,300.343,100.02,300.343,50.1683,null,67.1558,null,38.1055,100.02,40.123),(20,false,false,null,1,-5586,32767,-602231030,-468313281,31525,245,40.123,14.512555,62.640129358060165,23.940911286338412,300.343,71.1193,96.0935,95.0263,88.0094,100.02,73.1830,40.123,300.343,40.123,85.1319,100.02),(21,true,false,-1,8,868,21773,32679,-800848822,6,147483648,100.02,300.343,76.94700020940235,15.544687318864128,14.0265,300.343,61.0244,40.123,100.02,44.1985,19.0521,300.343,300.343,300.343,45.0813,62.0244),(22,false,false,127,-128,-32768,17278,1283172518,147483648,1,300.343,87.25913,24.94464,null,53.39684343837884,40.123,40.123,20.1610,300.343,38.1763,300.343,91.0316,24.1294,40.123,91.1445,300.343,30.0139),(23,null,false,-82,5,27925,-32768,147483648,398471216,-6320063,147483648,43.395927,16.977839,40.123,82.89956387452517,300.343,100.02,40.123,0.1926,98.1841,100.02,300.343,99.1989,86.0253,40.123,null,300.343),(24,true,false,83,127,30205,-32768,null,147483648,20240803,20240803,12.581072,100.02,100.02,100.02,97.1145,25.0743,34.0678,100.02,40.123,20.1024,96.1827,300.343,300.343,24.1978,300.343,4.0505),(25,false,false,113,-128,-4618,-21467,-119247765,174989684,702317944702217520,147483648,40.123,300.343,58.560202762643996,300.343,null,100.02,52.0910,100.02,3.0218,36.1052,50.1050,40.123,null,40.123,null,81.0179),(26,true,true,1,3,-20697,0,2147483647,620075510,32679,300.343,40.123,8.281405,40.123,97.91570642580545,11.1693,100.02,null,2.0452,300.343,25.1669,300.343,300.343,70.0238,43.1819,null,15.0432),(27,null,false,127,-44,null,245,null,0,147483648,5,100.02,300.343,89.8450409422548,57.325174157382484,null,63.1898,300.343,100.02,100.02,96.1695,17.1029,5.0219,40.123,300.343,83.0928,40.123),(28,false,true,113,1,0,-6709,-1425882860,-2087598432,3,245,100.02,100.02,40.123,60.0672399537993,null,40.123,null,41.0202,100.02,300.343,51.1719,22.0281,300.343,40.123,300.343,72.0791),(29,null,true,127,1,null,-22278,2147483647,1840700770,300.343,147483648,null,100.02,300.343,14.95002600079256,40.123,45.0593,97.0833,35.1485,62.1246,100.02,300.343,64.0744,76.1151,100.02,100.02,40.123),(30,false,true,33,-42,-32768,16362,32679,1006088622,300.343,32679,59.80597,40.123,null,100.02,21.1295,60.0501,null,300.343,300.343,100.02,40.123,300.343,100.02,100.02,300.343,40.123),(31,null,true,1,1,245,245,-705023047,32679,8,32679,75.33006,55.79653,300.343,47.96342481868689,100.02,50.1482,100.02,40.123,19.1875,40.123,300.343,54.0214,55.1434,100.0140,100.02,20.1242),(32,true,true,-49,127,-28555,245,32679,-90829271,20240803,547072466793656360,300.343,300.343,24.174808167853868,89.8900684249949,99.0005,44.0427,63.1797,27.0327,41.1618,72.1580,100.02,69.0721,300.343,300.343,12.0697,300.343),(33,true,true,35,127,-21581,18054,-1002479747,-1728926153,300.343,32679,40.834206,300.343,40.123,88.77366326336902,73.0084,85.1595,100.02,300.343,49.1751,67.0464,87.0275,47.1497,19.0097,47.0830,60.1890,40.123),(34,true,true,1,0,2277,-3386,1594446117,147483648,20240803,5499960,71.92467,300.343,100.02,53.410688011061026,89.0782,3.1433,3.0984,100.02,55.1683,100.02,74.0873,40.123,300.343,100.02,78.0152,40.123),(35,null,false,null,-55,null,-10974,32679,493636356,1554461046393220425,-27645,40.123,100.02,100.02,100.02,300.343,69.1455,100.02,100.02,100.02,40.123,39.0987,66.1241,null,2.0170,300.343,100.02),(36,null,true,27,-20,32767,-248,2059692545,-2147483648,6601532,0,300.343,300.343,300.343,71.8771269520815,null,100.02,85.0821,55.0036,100.02,24.0011,12.1437,78.0906,19.1944,300.343,44.0017,300.343),(37,false,true,1,8,-27173,245,147483648,93506455,300.343,0,40.123,300.343,1.0040607970764792,100.02,40.123,300.343,97.0175,100.02,80.1873,87.0884,17.0957,42.1547,300.343,300.343,7.1573,93.1389),(38,false,true,28,-42,32767,-18984,950068895,-1750955934,1,2,59.211044,1.5997872,null,39.34886398502719,40.123,40.123,null,100.02,300.343,100.02,100.02,21.1855,80.0006,69.0869,80.0807,36.0612),(39,false,false,-128,1,28786,-14044,147483648,-2147483648,245,300.343,63.86071,300.343,46.28329660185213,96.36479559210424,91.0924,300.343,61.0974,40.123,98.1421,100.02,40.123,300.343,40.123,100.02,23.0575,100.0449),(40,false,true,4,-42,0,12636,0,799928425,18859,-2371,100.02,97.34173,29.35646567962841,19.668686120910028,100.02,40.123,300.343,100.02,40.123,100.02,100.02,74.0232,61.1506,300.343,300.343,82.1167),(41,true,false,31,2,-14397,-26164,2147483647,-2055922720,14752,20240803,31.928955,11.286691,77.33833415128589,300.343,100.02,100.02,100.02,56.0428,40.123,40.1015,null,300.343,40.123,18.1702,39.1213,100.02),(42,false,true,1,-128,-10836,31207,null,-401468030,32679,-4893513,100.02,17.293558,40.123,51.54822524103674,100.02,40.123,100.1889,90.0092,null,8.1551,91.0819,100.02,300.343,62.1251,12.1637,40.123),(43,false,true,-50,127,245,-9499,-593434204,-2147483648,-3197120,32679,40.123,99.54466,49.23737153185137,65.06185744929992,43.1605,47.1822,300.343,40.123,86.1185,100.02,88.1995,6.0865,40.123,40.123,78.0026,40.123),(44,true,false,121,5,245,0,-1807646722,-1169080773,4178459,29100,95.27716,70.122375,35.4276186393606,300.343,4.1364,57.0360,3.1043,100.02,300.343,52.1051,null,48.1964,40.123,17.1598,null,40.123),(45,null,true,0,-102,1562,-29208,-308404284,2147483647,1,300.343,300.343,100.02,84.19632755530832,57.7169107222678,40.123,40.123,100.02,300.343,65.0476,96.0983,300.343,40.123,52.1000,100.02,22.0141,40.123),(46,false,false,-128,1,32767,-32768,147483648,862317003,-6345173,7,73.13168,55.965034,100.17342735668034,81.0433792157518,8.0514,24.0488,7.1562,300.343,null,58.0156,100.02,49.1321,100.02,54.1186,69.1003,100.02),(47,true,false,3,127,-2428,18058,147483648,259435153,1,-7360468428682842680,40.123,100.02,300.343,40.123,null,40.123,100.02,40.123,32.1581,300.343,null,73.0453,2.1577,29.1375,30.1488,40.123),(48,null,true,1,0,null,-18743,2147483647,-233529762,6,147483648,100.02,300.343,null,28.832947615497797,40.123,40.123,300.343,51.0908,65.0196,100.02,47.0712,100.02,14.1091,13.1306,null,100.02),(49,false,true,1,126,0,245,1404418041,-2147483648,-27417,245,40.123,300.343,14.803292159939625,37.776521406336386,40.123,43.0997,null,100.02,28.1714,39.1745,100.02,78.1121,85.1018,40.123,null,40.123),(50,true,true,-128,0,17506,-19233,928060045,-968094382,147483648,147483648,null,40.123,22.58245854456932,87.60945944280742,4.0550,7.1097,300.343,37.1549,300.343,300.343,74.1063,47.1902,100.02,300.343,94.1231,70.1391),(51,true,true,null,6,12355,20972,-420833573,1367773643,-3890253,8387476689501436345,100.02,300.343,87.05410559516945,100.02,5.1219,300.343,19.0517,300.343,3.1077,57.0513,null,100.02,83.0944,40.123,null,6.1304),(52,true,true,127,6,0,-22756,654719123,32679,null,-3080718,null,43.153564,null,63.062200847332235,64.1757,10.1427,29.0090,300.343,64.1496,40.123,43.1490,100.02,69.1899,80.1473,null,3.0733),(53,true,true,1,0,6830,-28441,-2147483648,963503490,147483648,3170207,83.754814,1.8227811,100.02,58.451635465970874,62.0259,88.0066,24.1511,300.343,null,40.123,300.343,70.1108,96.1089,76.1201,100.02,300.343),(54,false,true,20,-128,-32768,-29432,32679,2147483647,32679,20240803,76.52722,98.02416,63.21387051988944,40.123,100.02,300.343,12.1308,100.02,40.123,300.343,300.343,87.0184,100.02,300.343,44.1406,100.02),(55,false,true,null,117,30122,16666,-1550173665,-1494870150,null,1482819358272650863,300.343,76.16598,77.21551946423071,87.47986248815684,40.123,300.343,null,75.0855,49.1550,300.343,85.1219,40.0629,100.02,1.1426,300.343,98.1630),(56,null,true,127,0,18042,32767,0,2147483647,32679,20240803,100.02,26.286163,5.183864698359465,60.419389468392346,40.123,100.02,34.1515,72.1051,19.1828,300.343,300.343,40.123,100.02,40.123,300.343,100.02),(57,null,false,0,25,0,-32768,1668120939,-2147483648,245,300.343,8.957483,100.02,74.04929670728133,100.02,300.343,83.0333,40.123,91.1427,93.1833,40.123,40.123,59.0849,40.123,100.02,100.02,63.0824),(58,false,false,null,6,-12627,25341,32679,32679,245,-18848,14.538594,92.61009,28.04025495599968,300.343,null,40.123,22.0143,300.343,33.1907,40.123,100.02,300.343,39.0329,61.1527,5.1240,40.123),(59,null,true,9,-95,-32768,-24069,-1047251084,463155489,245,300.343,24.820452,40.123,43.74778099591234,55.539845373255744,70.0059,100.02,55.0268,100.02,40.123,40.123,300.343,40.123,100.02,40.123,100.02,100.02),(60,true,false,-128,-128,15805,24664,null,2147483647,300.343,7,49.240326,28.58755,78.19783953232441,26.200519632833316,100.02,96.1841,300.343,40.123,9.0768,100.02,81.0950,100.02,78.1179,100.02,null,40.123),(61,false,true,3,1,-13860,0,-2147483648,-1616672647,147483648,1,300.343,40.123,40.123,73.06602805164309,100.02,80.0096,null,70.0641,null,7.0982,83.0570,40.123,56.0610,83.0714,20.1656,100.02),(62,null,false,127,0,31992,-16832,1579711918,2147483647,300.343,6101263,64.585266,59.56007,83.69332124356997,100.02,null,40.123,4.1461,100.02,40.123,300.343,null,40.123,28.0577,300.343,300.343,100.02),(63,true,false,-128,0,-4159,245,147483648,41757331,1,20240803,100.02,100.02,65.58738442400104,89.32240697703746,31.1748,80.1877,40.123,300.343,91.0985,29.0750,86.0323,100.02,100.02,100.02,80.1498,40.123),(64,false,true,1,127,-16557,0,-1985104257,0,9,1,100.02,300.343,300.343,100.02,300.343,5.0042,null,40.1111,100.02,3.0885,null,86.0379,100.02,300.343,null,40.123),(65,false,false,0,3,32767,28823,null,32679,-21802,0,300.343,49.534836,59.37854469033925,300.343,null,83.1741,15.1613,40.123,84.0770,88.0951,19.0622,40.123,300.343,48.0820,100.02,300.343),(66,null,false,126,0,-32048,-27785,-2147483648,2147483647,147483648,245,81.342476,17.529161,80.2793141983029,100.82156374867995,88.1292,93.0266,40.123,300.343,29.1484,100.02,66.1397,300.343,300.343,100.02,null,100.02),(67,true,false,-128,0,245,22355,1606937656,0,5,245,40.123,85.46909,100.02,300.343,100.02,61.1880,74.0491,40.123,57.0988,100.02,40.123,300.343,40.123,26.0711,13.1249,80.1489),(68,null,false,3,1,-5723,32767,-2147483648,1998585079,245,147483648,0.8302286,100.02,100.02,29.91286703548176,62.1426,44.1871,95.1079,40.123,83.1947,100.02,null,300.343,40.123,100.02,40.123,89.0914),(69,true,false,null,-128,-22285,17637,2139352095,-1026889323,20240803,21038,40.123,40.123,71.2479317971375,100.02,300.343,3.1012,null,25.0630,300.343,8.0205,null,300.343,40.123,12.0072,40.123,48.1284),(70,null,false,-128,0,null,32767,866151793,0,300.343,1,100.02,22.772745,100.02,40.123,300.343,300.343,100.02,40.1362,85.1045,57.0423,93.1925,48.1466,40.123,42.1387,40.123,100.02),(71,true,false,1,0,245,-15199,0,1682957935,1,32679,47.658203,100.02,300.343,40.123,null,300.343,300.343,40.123,300.343,300.343,100.02,28.0038,42.1743,40.123,null,50.0117),(72,null,true,1,31,21669,-1197,0,-2147483648,32679,4528112,33.573883,64.29188,50.92734051547059,15.367888356606223,300.343,100.02,12.1497,57.1954,79.1693,77.1937,26.1772,100.02,300.343,300.343,8.1414,77.0290),(73,false,true,127,127,25706,25329,1023263009,32679,26200,20240803,97.54618,40.123,27.503011983005308,19.97810674796473,null,97.0935,null,100.02,null,100.02,94.1530,93.1843,100.02,40.123,40.123,100.02),(74,null,true,5,-106,-29269,-23856,0,0,-2170976,-32582,40.123,11.028486,2.5183566732160028,44.54309668957869,100.02,300.343,100.02,92.1376,96.0160,100.02,85.1356,4.1063,300.343,84.1108,40.123,100.02),(75,true,false,127,1,-22197,32767,1949766850,-2147483648,null,-5543639,21.571142,100.02,300.343,100.02,300.343,100.02,22.0722,100.02,27.0077,100.02,40.123,91.0051,300.343,300.343,67.0873,100.02),(76,true,false,127,127,245,0,32679,32679,-3846533548135585363,245,100.02,300.343,61.38543879914556,23.881139090062863,300.343,40.123,100.02,100.02,100.02,300.343,null,40.123,54.0558,100.02,55.1602,40.123),(77,false,true,0,0,-28913,0,32679,-2147483648,245,108954822763317083,97.504944,40.123,40.123,27.452781371491614,300.343,9.1958,12.0430,100.02,79.1577,46.1627,300.343,52.0817,40.123,65.1825,300.343,57.0987),(78,null,true,1,-128,19928,15233,0,1906126199,-5827520829230900217,3,100.02,55.513626,40.123,86.45729040432911,null,68.1445,53.0981,40.123,40.123,100.02,52.0057,1.1593,43.1824,75.1936,21.1504,40.123),(79,null,false,62,127,-1375,7079,-1810078488,0,1,-842283644995150167,18.873375,19.812044,0.09239759665896496,50.1599075730793,100.02,100.02,2.0606,100.02,40.123,300.343,12.0767,44.1073,300.343,84.0131,14.1248,40.123),(80,false,false,127,-74,32767,32767,406348391,-1524789913,245,3963615275036134392,40.123,100.02,75.90399227145431,100.02,null,73.0645,40.123,31.0848,300.343,14.1945,11.0300,93.0716,null,40.123,100.02,67.1887),(81,false,false,-128,-115,null,-8824,null,-1274877181,4238095985939191348,147483648,null,50.115902,5.116587898562866,90.55427479754299,null,300.343,null,40.123,100.02,40.123,40.123,100.02,74.1901,21.0636,58.1929,38.1830),(82,false,false,0,127,-10542,1115,703525872,-156071729,245,32679,null,88.95235,40.123,300.343,40.123,90.1234,null,35.0061,300.343,300.343,300.343,300.343,22.0821,60.0915,null,25.1671),(83,true,false,null,-128,-23366,17904,-1845879247,0,147483648,245,56.185734,98.85193,28.791363129340947,69.53273262180916,40.123,40.123,100.02,44.1043,100.02,300.343,100.02,5.0287,81.0042,40.123,300.343,40.123),(84,false,false,-128,127,null,-903,2147483647,-298576443,4326007499518926142,1,300.343,40.123,8.488206885521171,90.22086568911118,79.1075,84.1203,36.0691,100.0122,40.123,7.0557,91.1252,300.343,null,100.02,40.123,300.343),(85,true,true,59,20,-32768,-22364,147483648,1134056516,147483648,1,null,40.123,100.02,50.95124572797081,34.0075,48.1173,5.0180,9.1309,null,11.1694,44.1582,100.02,40.123,47.0938,26.1558,16.0771),(86,true,false,62,100,-13209,0,null,2147483647,-6882957,147483648,null,100.02,34.02659572164404,100.02,34.0098,40.123,50.1584,55.0513,null,26.0938,100.02,40.123,41.0845,82.1065,100.02,82.1410),(87,true,true,1,110,0,7964,0,-1612707728,-15102,147483648,27.3543,56.960598,40.123,300.343,300.343,300.343,51.0405,58.1095,null,300.343,300.343,40.123,40.123,50.1398,0.1660,100.02),(88,null,true,2,2,null,245,-1994755213,-2147483648,20240803,-2055497,33.082787,36.155426,100.02,75.9445455969295,null,300.343,89.0874,40.123,27.0510,85.1684,67.0026,72.1427,18.1930,31.1147,10.0659,11.1875),(89,null,true,18,72,31667,-18537,50385711,-2019108535,-26789,300.343,53.41752,64.563805,15.977002340673545,36.11005242038549,40.123,81.0956,35.0066,14.1764,null,23.0120,null,14.1528,300.343,100.02,84.1084,65.1933),(90,true,true,-128,-106,245,-3202,576364392,1696762574,1801544748428540677,1,null,86.865364,83.52225659799662,300.343,40.123,100.02,1.1245,65.1628,40.123,25.0485,null,100.02,40.123,25.0430,78.0278,1.1572),(91,false,true,96,7,32767,0,-2147483648,32679,8,20240803,31.439945,100.02,40.123,300.343,100.02,300.343,100.02,59.1978,5.0234,27.1617,40.123,38.0460,46.1356,300.343,100.02,18.0073),(92,null,true,-60,-32,-32768,-32768,2147483647,-1707297306,null,9,53.642704,300.343,92.21430934975321,89.51856007304167,100.02,40.1787,100.02,13.1243,300.343,70.0531,72.1695,68.1924,null,33.1963,100.02,10.1940),(93,null,false,null,1,245,-23966,-229883397,892520300,245,20240803,100.02,40.123,100.02,68.07177164188646,100.02,300.343,40.123,40.0709,87.1993,48.1822,84.0300,81.0583,68.1210,70.0513,24.0484,55.0348),(94,false,false,0,126,-5565,16334,-1500369240,2147483647,20240803,1,40.123,40.123,22.409783125381818,53.538538746410985,100.02,92.0354,100.02,300.343,300.343,88.0204,100.02,40.123,null,100.02,100.02,99.0716),(95,true,true,13,-103,-18191,-32768,null,0,300.343,-27590,100.02,46.513206,20.34480996068452,16.2012744082584,null,40.123,47.0734,27.1125,100.02,40.0675,null,40.123,53.1515,40.123,100.02,17.0719),(96,true,false,-25,0,-15441,245,-2147483648,-2094951540,4128659932999713281,-3014477361704267309,1.0252304,300.343,300.343,100.02,300.343,4.0299,null,40.123,null,95.1601,46.0039,31.0319,33.1251,49.1539,null,90.1318),(97,true,true,7,66,0,8597,-2147483648,2082358272,2539,245,40.123,9.645237,null,91.98940397815429,68.0136,76.0214,null,14.0094,300.343,73.1017,40.123,40.123,300.343,100.02,40.123,40.123),(98,false,false,null,-128,2658,0,2147483647,0,null,300.343,8.48215,300.343,300.343,70.31424485294733,100.02,300.343,300.343,40.123,100.02,40.123,100.02,36.0302,100.02,40.123,100.02,300.343),(99,true,false,1,1,null,-32768,-1227233525,0,3,3,45.120365,300.343,40.123,32.08155756681695,null,40.123,100.02,100.02,40.123,300.343,32.1876,95.1981,19.1851,68.1442,77.1439,300.343),(100,true,true,0,127,0,-32768,43026623,-1693013137,5018060789260282465,20240803,39.016026,51.351124,7.0261623993586495,300.343,300.343,100.02,11.0957,100.02,38.0553,40.123,22.1984,40.123,300.343,100.02,88.0393,81.1827),(101,false,true,-128,1,24323,26647,-1219608286,-2147483648,1,20240803,65.799225,28.868416,10.181899475050512,40.123,null,40.123,75.0513,300.343,null,46.1203,40.123,83.1503,39.1853,37.0077,null,300.343),(102,null,true,3,7,245,5533,124152548,193915138,0,8,40.123,100.02,40.123,15.435045819369767,81.0346,40.123,300.343,100.02,null,20.0112,300.343,76.1545,300.343,300.343,40.123,100.02),(103,false,true,0,-100,31066,23479,422438606,-149496060,147483648,5,40.123,79.40801,300.343,39.435633537608105,100.02,300.343,null,92.0144,0.0410,100.02,300.343,76.1794,100.02,36.1003,85.1865,100.02),(104,null,false,-128,-128,8616,32767,147483648,1718075742,null,24977,100.02,79.642685,100.02,26.711461273327185,40.123,81.0067,40.123,18.1762,33.0396,20.1293,42.0193,300.343,300.343,300.343,300.343,98.0503),(105,true,true,127,0,245,9380,147483648,147483648,null,300.343,null,300.343,100.02,100.02,18.1115,100.02,83.0080,82.1976,300.343,100.02,null,100.02,null,75.0449,78.1436,89.1410),(106,true,true,-39,-128,-16575,-14929,-1972652462,147483648,300.343,-2901473,28.91638,100.02,97.73573465631392,76.35445572091163,100.02,40.123,100.02,53.0278,null,62.1835,27.1195,30.1130,null,82.1932,25.1830,40.123),(107,false,true,null,-115,245,3557,1547797325,32679,7451546,1,100.02,9.934288,300.343,40.123,null,62.1662,100.02,40.123,null,64.0502,null,70.1488,100.02,40.123,100.02,46.1974),(108,null,false,81,25,31615,32767,-1569899733,0,-3286441,20240803,40.123,100.02,39.94254836124736,100.02,300.343,60.1307,300.343,97.1733,17.0098,18.1173,100.02,100.02,76.1069,300.343,100.02,40.123),(109,null,true,null,97,null,20625,-1312026698,-2147483648,1,245,100.02,300.343,300.343,2.087018889870059,39.0091,40.123,67.0813,1.1311,100.02,81.0368,52.1543,35.1617,null,300.343,300.343,100.02),(110,null,false,1,-110,-9605,-32768,2147483647,32679,2,32679,100.02,37.999928,47.15762507873273,40.123,69.0217,14.1567,100.02,27.0992,74.0342,100.02,6.0813,52.0089,67.0109,97.0502,40.123,100.02),(111,null,false,53,127,-12609,4725,104458880,-758525622,3013348,-8051978,300.343,85.78309,null,17.86424850123154,100.02,85.0096,300.343,17.0553,100.02,89.0451,68.1888,40.123,2.0136,14.1320,20.0970,95.1267),(112,null,true,1,127,32767,0,0,-181204112,-7769,300.343,300.343,24.86158,null,100.02,12.0528,5.0491,70.0618,300.343,95.1190,50.0241,null,40.123,100.02,40.123,13.0238,300.343),(113,null,false,-103,-54,null,-23247,-2147483648,1565107572,null,147483648,40.123,300.343,69.52143443753269,40.123,40.123,40.123,97.0816,79.1983,null,36.1032,null,300.343,300.343,54.1574,81.0281,12.1005),(114,null,true,127,-128,30108,-10269,1047943244,147483648,32679,1278162926834511692,null,45.2988,null,48.34738019585097,null,40.123,300.343,100.02,100.02,26.1202,79.0876,61.1514,40.123,95.0140,11.0472,40.123),(115,null,true,122,0,26174,245,147483648,-289447525,null,300.343,40.123,300.343,40.123,50.10516812711762,91.1473,40.123,95.1676,40.123,40.123,32.0531,100.02,300.343,90.0932,50.0650,40.123,48.0383),(116,true,true,1,-128,32767,245,-743484773,1133528555,null,-4462,28.942665,78.210526,100.02,100.02,null,40.123,74.0860,300.343,null,7.0398,40.123,22.0092,70.1124,99.0855,100.02,300.343),(117,null,false,127,-76,-6242,9953,-1388529113,1117902118,245,147483648,65.12925,94.87573,300.343,84.08118530362427,300.343,9.0203,50.0958,100.02,100.02,100.02,40.123,100.02,0.0641,300.343,null,3.0179),(118,null,false,-128,-128,-30764,-32768,0,32679,4192011898564589227,1,300.343,48.720806,300.343,300.343,36.1343,40.123,100.02,100.02,40.123,40.123,300.343,300.343,23.0690,99.1259,71.1940,100.02),(119,false,false,null,2,0,-9964,-1638010852,-2147483648,300.343,147483648,null,88.76886,300.343,51.972153632907514,null,65.1584,null,300.343,40.123,6.0150,3.0613,91.1639,65.0057,36.1160,82.0661,100.02),(120,null,false,127,60,-17072,-24305,-695080826,0,245,245,100.02,100.02,40.123,40.123,40.123,60.0610,85.0021,8.0322,100.02,100.02,40.123,45.1733,99.1817,84.0376,55.0536,300.343),(121,null,false,1,0,-2767,-9273,1478135495,32679,2881140859769652250,-15040,77.91241,100.02,89.28503501771756,82.31653292545549,100.02,27.1697,null,300.343,100.02,79.1965,null,100.02,100.02,26.1863,100.02,86.0545),(122,null,false,0,7,-1298,6968,32679,-553231962,300.343,20240803,75.41454,19.38961,100.02,22.87081519143626,null,100.02,300.343,40.123,60.0005,300.343,6.0033,19.0163,300.343,300.343,300.343,40.123),(123,null,false,1,-128,-32459,30567,-2147483648,147483648,300.343,32679,85.95871,300.343,300.343,88.23349841859975,83.1243,40.123,36.0062,28.0244,78.1511,300.343,null,40.123,null,40.123,12.0330,96.0282),(124,false,false,127,-56,16609,29019,1919988745,-2147483648,null,20240803,9.960259,40.123,64.4276470734917,67.69034261730734,100.02,300.343,30.0195,100.02,300.343,300.343,100.02,69.0774,100.02,100.02,52.0927,40.123),(125,false,false,38,1,-11224,-18790,2147483647,2147483647,147483648,245,50.67896,100.02,300.343,40.123,71.1867,17.0300,100.02,95.0291,300.343,33.0339,100.02,50.1826,22.1188,15.0461,300.343,81.0832),(126,false,false,0,-110,32767,-14386,147483648,32679,null,300.343,78.18328,40.123,300.343,100.02,20.0887,40.123,100.02,300.343,40.123,40.123,40.123,64.0699,null,91.0765,300.343,38.1851),(127,true,false,72,-128,-336,30617,1259754652,2108044612,-28047,9,68.56738,300.343,60.94303006453322,100.02,72.0365,300.343,53.0241,100.02,null,80.1020,45.0265,300.343,40.123,40.123,null,18.1104),(128,false,true,-128,0,25675,27385,-112276230,32679,-10413,20240803,88.74651,99.25312,100.02,100.65424694588411,100.02,46.0395,null,100.02,null,95.0482,100.02,300.343,null,61.1176,100.02,300.343),(129,true,true,-3,1,245,11887,null,2147483647,-7400584094873709947,1,14.39657,100.02,300.343,40.3636405460102,null,31.0690,100.02,300.343,null,96.1680,100.02,4.0498,300.343,300.343,300.343,300.343),(130,null,false,null,5,0,575,2147483647,0,-15301,1209491,300.343,91.30643,null,40.123,100.02,300.343,300.343,40.123,100.02,23.1428,100.02,20.1225,100.02,300.343,40.123,40.123),(131,false,true,1,1,20429,29076,-1762767490,591743971,1,32679,40.123,300.343,64.76554944613694,5.929978974610336,88.1899,66.0615,7.0244,300.343,8.1396,100.02,79.1989,55.1193,null,40.123,97.1875,100.02),(132,null,false,1,1,-2841,245,1794737794,249688774,32679,0,40.123,100.02,null,40.123,null,300.343,300.343,300.343,null,26.0946,300.343,82.0601,null,28.0584,300.343,100.02),(133,true,false,-128,2,-15316,3718,32679,-690297108,null,147483648,null,11.527625,null,36.182018543784004,100.1448,300.343,84.0691,94.0152,20.1872,68.1781,20.1761,100.02,4.1596,40.123,38.0850,26.0728),(134,true,true,71,-77,1243,-29476,32679,2147483647,300.343,9,40.123,2.1161988,44.721238188178454,100.02,40.123,75.1330,40.123,4.1789,100.02,47.1459,100.02,52.1343,300.343,12.1044,300.343,100.02),(135,false,false,1,5,-32768,245,832514291,-1854940774,32679,300.343,40.123,59.55407,89.35441854005492,24.042795943672747,300.343,7.1391,40.123,40.123,24.1904,99.1677,14.0423,100.02,100.02,100.02,40.123,300.343),(136,null,true,1,-75,31689,-18322,-285447156,147483648,null,20240803,40.123,40.123,84.0139915724961,64.01879641982227,100.02,40.123,40.123,11.1435,40.123,62.1781,74.0872,21.1737,20.0073,300.343,300.343,100.02),(137,true,true,-128,-112,-4927,-8096,147483648,32679,32679,32679,40.123,58.53123,21.48699460605266,80.99727243439341,85.0584,78.0000,76.1551,300.343,100.02,100.02,94.0008,40.123,300.343,100.02,300.343,28.0385),(138,true,false,-128,75,null,23645,-2147483648,2147483647,245,7428,94.312706,100.02,27.34384759452868,40.123,19.0207,40.123,21.0118,90.1011,40.123,41.1255,300.343,6.0253,300.343,40.123,12.0525,40.1869),(139,false,true,1,8,-24812,31452,-2147483648,526911742,32679,300.343,55.73405,300.343,17.800197355863794,100.02,40.123,100.02,5.1893,100.02,300.343,12.0620,8.0921,300.343,null,300.343,300.343,40.123),(140,false,false,-42,101,-30538,2630,-186234472,-2147483648,245,1,83.33636,49.598263,88.94428964612923,300.343,300.343,100.02,40.123,22.0527,40.123,40.123,68.0934,300.343,65.0857,87.0248,null,40.123),(141,null,true,127,-128,-27595,-12956,2147483647,-1902241305,1533006,11537,0.27623007,300.343,70.0590946918003,100.02,300.343,50.0995,40.123,88.1809,300.343,50.0149,null,79.0088,56.0563,100.02,3.1822,40.123),(142,false,false,0,-128,23715,1796,2147483647,-2073273751,2,32679,40.123,20.084553,38.363932232357705,40.89554612866681,68.0723,100.02,300.343,40.123,null,26.1041,300.343,100.02,25.0477,73.1305,300.343,100.02),(143,null,false,-127,54,4866,-14672,2069236806,164100083,6536064,-27229,38.150673,28.145409,40.123,43.271153634465826,6.0183,87.1456,90.0555,100.02,56.0633,65.1510,300.343,64.0985,96.0445,51.1169,300.343,100.02),(144,null,true,8,1,0,245,32679,0,245,245,300.343,49.1595,null,96.7699852244762,12.0629,47.0668,100.02,79.0583,40.123,76.0360,6.1156,300.343,87.0120,37.0374,20.0107,40.123),(145,false,true,127,127,231,245,0,2147483647,-4155201,147483648,55.094093,67.009796,8.80227098959567,96.97187513932896,87.0709,68.0667,91.1983,63.1604,100.02,100.02,65.0108,90.1654,41.1876,5.0705,26.0387,300.343),(146,false,true,127,9,32767,32767,658418135,-437486193,7,245,null,40.123,100.02,300.343,79.1581,19.1866,40.123,30.1889,300.343,300.343,80.1265,300.343,null,100.02,300.343,300.343),(147,null,true,-11,6,-10644,32767,32679,-1284237248,1,32679,10.248305,50.55562,300.343,34.47185435551129,45.1925,80.1317,100.02,300.343,100.02,300.343,26.1244,300.343,100.02,300.343,null,40.123),(148,true,true,127,-128,-4878,32767,32679,-339538000,482554,4821,71.634605,36.63903,2.365454209953471,22.663615985934936,null,100.02,34.0122,100.02,40.123,300.343,97.0987,28.0643,64.0605,300.343,100.02,5.0883),(149,false,true,0,5,245,60,1824478307,147483648,2,-4476632980072869204,93.32383,42.04267,100.02,51.37715926909345,40.123,60.1327,100.02,100.02,300.343,99.1742,null,40.123,36.1038,8.0276,41.1160,100.02),(150,null,false,null,53,null,8023,1383458937,-401715533,20240803,-27180,null,300.343,63.48460867022761,8.985522002082849,8.0315,59.1740,100.02,300.343,100.02,67.0608,6.0489,51.1445,100.02,40.123,null,40.123),(151,false,true,1,-128,245,245,706650098,-1977203866,null,7,62.289223,300.343,82.39375057254898,1.0657909024939936,300.343,7.1881,82.1928,300.343,100.02,40.123,300.343,100.02,null,73.0651,300.343,300.343),(152,false,true,126,119,-26868,-15616,1587788697,-2147483648,-4924529,300.343,40.123,30.292782,null,300.343,28.1303,300.343,48.0032,300.343,40.0588,40.123,15.0326,300.343,76.0864,40.123,41.0419,55.0078),(153,true,true,6,-128,-32768,32767,2147483647,-107187645,14230,8313294,69.55337,50.10263,70.61695352071436,100.02,300.343,100.02,40.123,300.343,null,77.0521,100.02,300.343,40.123,15.1432,null,4.1525),(154,true,false,null,-128,-32768,-7269,0,2147483647,null,-24117,10.93608,96.51051,13.662109207650328,46.39266611215844,69.1678,40.123,75.1448,20.0209,300.343,100.02,null,300.343,76.1590,86.1793,89.1705,100.02),(155,true,false,1,3,-20965,1397,32679,147483648,-15514,24658,4.333004,36.363426,68.32207447960896,100.02,15.1599,1.0341,40.123,100.02,300.343,300.343,46.1646,100.02,300.343,22.0230,9.0330,100.02),(156,null,true,2,0,245,-8890,-2147483648,-1869054459,null,-5594434,100.02,300.343,null,40.123,40.123,58.1789,300.343,33.0526,55.1202,300.343,null,6.1861,69.1035,40.123,100.02,40.123),(157,null,false,4,0,null,32767,0,32679,300.343,245,74.3095,40.123,100.02,0.9558084828441511,40.123,42.0003,null,97.0759,52.1753,88.0094,100.02,300.343,1.1874,100.02,40.123,62.0600),(158,null,true,-128,-105,-32768,-30205,-2147483648,668511903,-5724613,8,100.02,51.563293,39.63710534303279,100.02,40.123,17.1668,68.1547,91.0505,300.343,55.1339,100.02,40.123,100.02,57.1705,10.1103,100.02),(159,true,true,106,-15,8915,29227,-2147483648,-20489220,245,20240803,97.018875,100.02,300.343,50.08526545127984,null,40.123,300.343,66.1420,40.123,300.343,40.123,40.123,100.02,5.1234,40.123,40.123),(160,null,true,-122,-128,null,-27283,860707403,-1846775647,32679,20240803,54.639565,57.168278,43.51439085008457,9.930887455136805,300.343,29.0291,100.02,100.02,null,100.02,24.1941,300.343,66.1524,13.1061,300.343,76.1610),(161,false,false,55,1,-24856,0,null,273330785,6228192824530271488,-23231,4.166127,100.02,73.47696626472431,15.341997224491761,100.02,27.0868,4.1831,16.1381,100.02,79.0886,66.1674,300.343,20.1287,58.1149,53.0946,90.0471),(162,false,false,0,1,23677,0,2147483647,147483648,32679,300.343,null,82.11983,100.02,68.1183108905539,51.0759,300.343,2.0146,79.0170,1.0469,100.02,33.0449,300.343,2.0509,100.02,89.0122,53.0934),(163,null,true,-20,-80,21710,17802,-2147483648,-44908386,147483648,-30892,69.70228,50.63278,300.343,300.343,8.1179,40.123,49.1359,40.123,100.02,33.1236,0.0994,93.1043,48.1059,40.123,300.343,69.0951),(164,true,false,5,69,245,-32768,null,1122572837,32679,1983361535998042679,40.123,29.683115,45.13713825982192,100.02,null,300.343,300.343,300.343,null,51.0455,100.02,32.0948,null,100.02,3.0196,40.123),(165,true,false,-3,39,-32768,-14223,-407001947,-88610448,300.343,300.343,62.86208,300.343,22.02080052202581,18.865467615423626,300.343,300.343,87.0985,300.343,40.123,100.02,74.0906,40.123,300.343,81.0434,79.0259,22.1417),(166,false,true,96,-17,1109,-24909,1781166156,-1454435420,-8311153686603853007,147483648,53.31313,40.123,36.08041243968696,93.81041771670793,100.02,100.1722,null,40.123,null,1.0363,59.0047,67.1107,42.0603,100.02,300.343,300.343),(167,true,true,127,-70,-21317,-19368,274090080,1552234968,32679,300.343,39.997547,51.8978,58.70529247129719,15.019196105972863,60.0376,48.1921,300.343,76.1680,null,100.02,100.1999,300.343,100.02,40.123,300.343,52.0149),(168,true,false,45,0,-26860,-10177,-1216625010,2032115995,20240803,300.343,69.06438,100.02,32.430365161482186,28.54698088552074,300.343,25.0491,80.1805,14.0454,100.02,40.123,40.123,300.343,64.0859,300.343,69.1063,40.123),(169,false,true,-74,127,32767,-32768,null,1989919147,1,1,64.49969,23.08643,300.343,100.02,86.0643,21.1390,null,300.343,100.02,40.123,100.02,100.02,51.1161,25.1942,97.0069,62.1089),(170,null,false,42,26,-29673,-6767,-2147483648,-1385425906,32679,20240803,100.02,300.343,40.123,40.123,27.0763,40.123,300.343,300.343,22.0888,100.02,null,26.0066,300.343,17.1600,33.0503,67.1291),(171,null,true,6,23,-4581,32767,-2147483648,32679,1639,-810333,32.13477,59.64614,100.02,87.93132379078565,88.1012,60.1940,35.1905,100.02,100.02,100.02,40.123,300.343,300.343,46.1793,300.343,56.0742),(172,true,false,49,-18,10647,32767,0,0,-4705967,995543,39.60285,57.59544,19.87610524684921,17.500848987419083,null,300.343,null,62.1315,300.343,93.1966,7.0544,2.0692,40.123,11.1242,25.1992,40.123),(173,false,false,1,-128,-4029,32767,-1468225329,-1331144674,147483648,300.343,37.145172,82.59502,100.171958220766,73.91801775541255,29.1411,66.0227,null,300.343,300.343,44.1453,300.343,100.0322,36.0108,92.0456,null,100.02),(174,false,false,1,85,24704,-32768,-1700886455,942495967,245,300.343,40.123,100.02,83.07083469187177,83.361740773243,44.1926,100.02,31.1582,40.123,300.343,95.1907,100.02,95.0525,87.1093,70.1932,300.343,44.1647),(175,true,true,0,-2,26480,7005,-354093593,-575936753,147483648,8261132,300.343,300.343,78.90413425966202,79.50226474352503,95.1729,5.1937,34.0443,100.02,100.02,100.02,15.1668,92.0063,100.02,34.0381,32.1136,100.02),(176,null,true,-17,127,null,-13578,-784045807,2007709101,300.343,300.343,null,92.845665,40.123,92.05963372931738,100.0679,100.02,9.0409,28.1107,94.1039,300.343,100.02,100.02,100.02,85.1842,null,75.1707),(177,true,true,1,1,2540,18797,0,-1536075223,147483648,20240803,300.343,52.06142,null,5.738342067117419,300.343,300.343,40.123,69.1197,63.0400,95.0953,10.1670,40.123,null,27.0352,7.0592,100.02),(178,null,true,127,-128,10516,-17295,2147483647,2147483647,147483648,-11385,35.60083,88.3799,95.66123829640617,16.0590735353562,28.1373,300.343,100.02,100.02,2.1455,100.02,100.02,44.1825,6.0106,51.0764,37.1739,100.02),(179,true,true,null,1,-119,32767,147483648,0,null,300.343,54.11735,2.9736354,5.5212872678061204,70.14211472476848,100.02,28.1085,40.123,300.343,100.02,300.343,57.0599,38.0298,97.1411,27.1211,78.1772,19.1982),(180,true,true,1,1,null,245,147483648,1454328724,-15403,300.343,33.222767,40.123,72.79185042565685,59.164033988993005,40.123,24.0907,70.0489,40.123,56.1604,64.0264,300.343,32.1469,300.343,40.123,100.02,68.1032),(181,false,true,6,0,-13357,-23853,-1783523447,206380972,-14933,20240803,null,73.067,43.00425396223879,100.02,57.1678,40.123,300.343,300.343,45.1238,40.123,100.02,40.123,300.343,16.0510,40.123,40.123),(182,true,true,-79,1,13944,245,0,333012856,245,300.343,66.92514,17.140984,15.116051354884547,300.343,7.1818,0.0419,300.343,40.123,41.0495,300.343,40.123,16.1287,0.0291,13.1787,100.02,40.123),(183,false,false,101,-128,245,26140,2111655080,147483648,1,300.343,72.77176,99.59849,89.76221878263951,40.123,65.1212,77.1425,null,100.02,16.0480,100.02,40.123,58.0354,300.343,10.0163,300.343,53.1106),(184,null,false,93,20,-12468,32767,2147483647,-1919350601,32679,245,300.343,300.343,89.97542003460438,83.07797527515272,null,40.123,54.0045,90.1450,40.123,53.0251,40.123,9.0271,100.02,40.123,100.02,300.343),(185,false,false,127,4,-30605,8961,-1603737214,32679,20240803,32679,100.02,73.1095,null,0.2554223846999049,40.123,23.1967,40.123,40.123,300.343,28.1916,100.02,40.123,62.1409,60.1379,300.343,42.1297),(186,null,false,1,-128,-11525,31446,2147483647,0,245,9,84.81564,78.88689,100.02,88.33230973847827,null,30.0019,98.0200,13.0767,30.0451,57.1554,57.0247,43.0648,40.123,300.343,300.343,40.123),(187,false,true,null,127,245,0,2005320865,32679,32679,245,6.6226397,40.123,300.343,22.045765620672245,100.02,40.123,98.0871,16.0154,100.02,40.123,19.1988,1.1923,48.0583,74.0135,null,100.02),(188,true,true,-25,-54,245,-8351,-2054730153,-1400175999,9,-15883,56.278236,49.124416,84.50003047597744,40.123,79.0664,100.02,21.0786,76.0055,40.123,45.1528,59.0995,40.0736,72.0219,36.1395,58.1532,40.123),(189,false,false,127,16,7527,0,2147483647,147483648,32679,20240803,40.123,77.93991,100.02,40.123,51.0606,65.1838,40.123,36.0241,71.0078,300.343,300.343,8.0658,100.02,40.123,20.1972,84.0992),(190,true,true,-98,0,245,0,null,2147483647,3,32679,300.343,56.213825,null,300.343,null,22.1118,22.0907,40.123,98.0671,100.02,100.1521,58.0234,40.123,100.02,40.123,88.0260),(191,true,true,127,-78,245,-32768,983178148,-1796395082,32679,147483648,40.123,40.123,null,40.123,null,100.02,300.343,100.02,null,100.02,300.343,20.0124,89.1252,300.343,40.123,100.02),(192,true,true,68,-128,-3705,13968,1020106271,-484224210,245,7,40.123,98.75088,63.300388151527855,64.63230652910728,null,300.343,null,84.1756,40.123,100.02,40.123,300.343,4.0929,88.1815,100.02,86.0682),(193,null,false,-17,-110,-32768,22171,-2147483648,147483648,5467206147096318931,20240803,72.185394,72.190216,23.628436073359932,72.51017191732922,40.123,43.0124,300.343,25.1762,null,300.343,300.343,28.1133,54.0435,55.0702,23.0567,100.02),(194,false,false,55,0,18123,7302,-1962777107,147483648,19480,1,null,100.02,45.58539012856048,59.57771833366333,82.1464,100.02,43.1109,300.343,100.02,39.1988,2.0388,45.0857,null,25.1965,null,7.1684),(195,false,false,-128,1,14187,245,1996009108,32679,3176594,-1361625,300.343,85.83407,49.41130397186706,78.85429657486976,100.02,85.1590,40.123,33.0503,null,100.02,null,100.02,300.343,100.02,41.0914,82.0151),(196,null,false,54,65,-32768,1256,-2147483648,-1188656418,null,245,10.657936,87.426674,300.343,95.2127316395285,42.0167,1.0607,19.1865,40.123,null,80.0223,null,2.0212,null,3.0599,300.343,300.343),(197,null,true,9,-128,245,-22687,-702035247,156461619,1,32679,16.704918,27.144121,43.0076514716217,79.53961659623093,18.0086,90.1809,57.0672,100.02,300.343,40.123,40.123,300.343,7.1142,100.02,3.1152,100.02),(198,null,false,20,-91,8077,25455,-2147483648,771014562,6033356893662555686,2244,300.343,87.73025,7.1216681183492145,51.66517820236684,null,100.02,40.123,52.1484,26.1710,16.0758,null,300.343,76.0330,77.1226,100.02,40.123),(199,true,true,-78,-4,-20877,10649,339605146,-2132984156,245,20240803,82.54591,300.343,null,17.455725893098002,65.0025,65.1163,null,100.02,null,60.0496,4.0522,40.123,93.1273,100.02,31.1751,100.02);
    """

    qt_sql """ select LAST_VALUE(col_tinyint_undef_signed_not_null) over (partition by col_double_undef_signed_not_null, col_int_undef_signed, (col_float_undef_signed_not_null - col_int_undef_signed), round_bankers(col_int_undef_signed) order by pk rows between unbounded preceding and 4 preceding) AS col_alias56089 from table_200_undef_partitions2_keys3_properties4_distributed_by53 order by col_alias56089;  """

    order_qt_multi_winf1 """
        select *
            from (
                select
                row_number() over(partition by c1 order by c2) rn,
                lead(c2, 2, '') over(partition by c1 order by c2)
                from (
                  select 1 as c1, 'a' as c2
                  union all
                  select 1 as c1, 'b' as c2
                  union all
                  select 1 as c1, 'c' as c2
                  union all
                  select 1 as c1, 'd' as c2
                  union all
                  select 1 as c1, 'e' as c2
                )t
            )a where rn=1
    """
    order_qt_multi_winf2 """
        select *
            from (
                select
                row_number() over(partition by c1 order by c2) rn,
                sum(c2) over(order by c2 range between unbounded preceding and unbounded following)
                from (
                  select 1 as c1, 5 as c2
                  union all
                  select 1 as c1, 6 as c2
                  union all
                  select 1 as c1, 7 as c2
                  union all
                  select 1 as c1, 8 as c2
                  union all
                  select 1 as c1, 9 as c2
                )t
            )a where rn=1
    """

    // test first value second param is not constant
    test {
        sql "select first_value(c1,c1) over() from window_test"
        exception "The second parameter of first_value must be a constant or a constant expression, and the result of the calculated constant or constant expression must be true or false."
    }

    test {
        sql "select last_value(c1,c1) over() from window_test"
        exception "The second parameter of last_value must be a constant or a constant expression, and the result of the calculated constant or constant expression must be true or false."
    }

    test {
        sql "select first_value(c1,cast('abc' as boolean)) over() from window_test"
        exception "The second parameter of first_value must be a constant or a constant expression, and the result of the calculated constant or constant expression must be true or false."
    }
    test {
        sql "select first_value(c1,'') over() from window_test"
        exception "The second parameter of first_value must be a constant or a constant expression, and the result of the calculated constant or constant expression must be true or false."
    }
    test {
        sql "select last_value(c1,'345_a') over() from window_test"
        exception "The second parameter of last_value must be a constant or a constant expression, and the result of the calculated constant or constant expression must be true or false."
    }
    sql "select last_value(c1,cast('67' as boolean)) over() from window_test"
    sql "select first_value(c1,cast(56 as boolean)) over() from window_test"
    sql "select last_value(c1,cast(56 as boolean)) over() from window_test"
    sql "select first_value(c1,cast('true' as boolean)) over() from window_test"
    sql "select last_value(c1,cast('false' as boolean)) over() from window_test"
    sql "select first_value(c1,cast('1' as boolean)) over() from window_test"
    sql "select last_value(c1,cast('0' as boolean)) over() from window_test"
    sql "select first_value(c1,true) over() from window_test"
    sql "select last_value(c1,false) over() from window_test"
    sql "select first_value(c1,1) over() from window_test"
    sql "select last_value(c1,0) over() from window_test"

    qt_first_value_false "select last_value(c1,false) over(partition by c2 order by c1) from window_test order by 1"
    qt_last_value_false "select first_value(c1,false) over(partition by c2 order by c1) from window_test order by 1"
}
