// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.literal.format;

import java.util.Objects;

/**
 * StringInspect, a simple lexer can save and move the index
 */
public class StringInspect {
    public final String str;
    private int index;

    public StringInspect(String str) {
        this.str = Objects.requireNonNull(str, "str cannot be null");
    }

    public boolean eos() {
        return index >= str.length();
    }

    public int remain() {
        return str.length() - index;
    }

    public char lookAt() {
        return str.charAt(index);
    }

    public void step() {
        this.index++;
    }

    public void step(int step) {
        this.index += step;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public char lookAndStep() {
        return str.charAt(index++);
    }

    public int index() {
        return index;
    }
}
