// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#include "result_sink_operator.h"

#include <memory>

#include "pipeline/exec/operator.h"
#include "runtime/buffer_control_block.h"
#include "vec/sink/vresult_sink.h"

namespace doris {
class DataSink;
} // namespace doris

namespace doris::pipeline {

ResultSinkOperatorBuilder::ResultSinkOperatorBuilder(int32_t id, DataSink* sink)
        : DataSinkOperatorBuilder(id, "ResultSinkOperator", sink) {};

OperatorPtr ResultSinkOperatorBuilder::build_operator() {
    return std::make_shared<ResultSinkOperator>(this, _sink);
}

ResultSinkOperator::ResultSinkOperator(OperatorBuilderBase* operator_builder, DataSink* sink)
        : DataSinkOperator(operator_builder, sink) {};

bool ResultSinkOperator::can_write() {
    return _sink->_sender->can_sink();
}
} // namespace doris::pipeline