/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowserSorterDialog
extends Dialog {
    public static final String DIALOG_TITLE = Messages.getString("BrowserSorterDialog.BrowserSorting");
    public static final String SORT_BY_NONE = Messages.getString("BrowserSorterDialog.NoSorting");
    public static final String SORT_BY_RDN = Messages.getString("BrowserSorterDialog.RDN");
    public static final String SORT_BY_RDN_VALUE = Messages.getString("BrowserSorterDialog.RDNValue");
    private BrowserPreferences preferences;
    private Button leafEntriesFirstButton;
    private Button containerEntriesFirstButton;
    private Button mixedButton;
    private Button metaEntriesLastButton;
    private Combo sortEntriesByCombo;
    private Button sortEntriesAscendingButton;
    private Button sortEntriesDescendingButton;
    private Button sortSearchesAscendingButton;
    private Button sortSearchesDescendingButton;
    private Button sortSearchesNoSortingButton;
    private Button sortBookmarksAscendingButton;
    private Button sortBookmarksDescendingButton;
    private Button sortBookmarksNoSortingButton;
    private Text sortLimitText;

    public BrowserSorterDialog(Shell parentShell, BrowserPreferences preferences) {
        super(parentShell);
        this.preferences = preferences;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            int sortLimit = this.preferences.getSortLimit();
            try {
                sortLimit = Integer.parseInt(this.sortLimitText.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {}
            IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
            store.setValue("browserLeafEntriesFirst", this.leafEntriesFirstButton.getSelection());
            store.setValue("browserContainerEntriesFirst", this.containerEntriesFirstButton.getSelection());
            store.setValue("browserMetaEntriesLast", this.metaEntriesLastButton.getSelection());
            store.setValue("browserSortOrder", this.sortEntriesDescendingButton.getSelection() ? 2 : 1);
            store.setValue("browserSortBy", this.sortEntriesByCombo.getSelectionIndex() == 2 ? 2 : (this.sortEntriesByCombo.getSelectionIndex() == 1 ? 1 : 0));
            store.setValue("browserSortLimit", sortLimit);
            if (this.sortSearchesAscendingButton.getSelection()) {
                store.setValue("browserSortSearchesOrder", 1);
            } else if (this.sortSearchesDescendingButton.getSelection()) {
                store.setValue("browserSortSearchesOrder", 2);
            } else if (this.sortSearchesNoSortingButton.getSelection()) {
                store.setValue("browserSortSearchesOrder", 0);
            }
            if (this.sortBookmarksAscendingButton.getSelection()) {
                store.setValue("browserSortBookmarksOrder", 1);
            } else if (this.sortBookmarksDescendingButton.getSelection()) {
                store.setValue("browserSortBookmarksOrder", 2);
            } else if (this.sortBookmarksNoSortingButton.getSelection()) {
                store.setValue("browserSortBookmarksOrder", 0);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        this.createGroupEntriesGroup(composite);
        this.createSortEntriesGroup(composite);
        this.createSortSearchesGroup(composite);
        this.createSortBookmarksGroup(composite);
        this.createSortLimitGroup(composite);
        BrowserSorterDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createGroupEntriesGroup(Composite composite) {
        Group groupEntriesGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserSorterDialog.GroupEntries"), (int)1);
        Composite groupEntriesButtonsComposite = BaseWidgetUtils.createColumnContainer((Composite)groupEntriesGroup, (int)3, (int)1);
        this.leafEntriesFirstButton = BaseWidgetUtils.createRadiobutton((Composite)groupEntriesButtonsComposite, (String)Messages.getString("BrowserSorterDialog.LeafEntriesFirst"), (int)1);
        this.leafEntriesFirstButton.setToolTipText(Messages.getString("BrowserSorterDialog.LeafEntriesFirstToolTip"));
        this.leafEntriesFirstButton.setSelection(this.preferences.isLeafEntriesFirst());
        this.containerEntriesFirstButton = BaseWidgetUtils.createRadiobutton((Composite)groupEntriesButtonsComposite, (String)Messages.getString("BrowserSorterDialog.ContainerEntriesFirst"), (int)1);
        this.containerEntriesFirstButton.setToolTipText(Messages.getString("BrowserSorterDialog.ContainerEntriesFirstToolTip"));
        this.containerEntriesFirstButton.setSelection(this.preferences.isContainerEntriesFirst());
        this.mixedButton = BaseWidgetUtils.createRadiobutton((Composite)groupEntriesButtonsComposite, (String)Messages.getString("BrowserSorterDialog.Mixed"), (int)1);
        this.mixedButton.setToolTipText(Messages.getString("BrowserSorterDialog.MixedToolTip"));
        this.mixedButton.setSelection(!this.preferences.isLeafEntriesFirst() && !this.preferences.isContainerEntriesFirst());
        this.metaEntriesLastButton = BaseWidgetUtils.createCheckbox((Composite)groupEntriesGroup, (String)Messages.getString("BrowserSorterDialog.MetaEntriesLast"), (int)1);
        this.metaEntriesLastButton.setToolTipText(Messages.getString("BrowserSorterDialog.MetaEntriesLastToolTip"));
        this.metaEntriesLastButton.setSelection(this.preferences.isMetaEntriesLast());
    }

    private void createSortEntriesGroup(Composite composite) {
        Group sortEntriesGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserSorterDialog.SortEntries"), (int)1);
        Composite sortByComposite = BaseWidgetUtils.createColumnContainer((Composite)sortEntriesGroup, (int)4, (int)1);
        BaseWidgetUtils.createLabel((Composite)sortByComposite, (String)Messages.getString("BrowserSorterDialog.SortBy"), (int)1);
        this.sortEntriesByCombo = BaseWidgetUtils.createReadonlyCombo((Composite)sortByComposite, (String[])new String[]{SORT_BY_NONE, SORT_BY_RDN, SORT_BY_RDN_VALUE}, (int)0, (int)1);
        this.sortEntriesByCombo.select(this.preferences.getSortEntriesBy() == 2 ? 2 : (this.preferences.getSortEntriesBy() == 1 ? 1 : 0));
        this.sortEntriesByCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserSorterDialog.this.sortEntriesAscendingButton.setEnabled(BrowserSorterDialog.this.sortEntriesByCombo.getSelectionIndex() != 0);
                BrowserSorterDialog.this.sortEntriesDescendingButton.setEnabled(BrowserSorterDialog.this.sortEntriesByCombo.getSelectionIndex() != 0);
            }
        });
        this.sortEntriesAscendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortByComposite, (String)Messages.getString("BrowserSorterDialog.Ascending"), (int)1);
        this.sortEntriesAscendingButton.setSelection(this.preferences.getSortEntriesOrder() == 1);
        this.sortEntriesAscendingButton.setEnabled(this.sortEntriesByCombo.getSelectionIndex() != 0);
        this.sortEntriesDescendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortByComposite, (String)Messages.getString("BrowserSorterDialog.Descending"), (int)1);
        this.sortEntriesDescendingButton.setSelection(this.preferences.getSortEntriesOrder() == 2);
        this.sortEntriesDescendingButton.setEnabled(this.sortEntriesByCombo.getSelectionIndex() != 0);
    }

    private void createSortSearchesGroup(Composite parent) {
        Group sortSearchesGroup = BaseWidgetUtils.createGroup((Composite)parent, (String)Messages.getString("BrowserSorterDialog.SortSearches"), (int)1);
        Composite sortSearchesComposite = BaseWidgetUtils.createColumnContainer((Composite)sortSearchesGroup, (int)3, (int)1);
        this.sortSearchesAscendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortSearchesComposite, (String)Messages.getString("BrowserSorterDialog.Ascending"), (int)1);
        this.sortSearchesAscendingButton.setSelection(this.preferences.getSortSearchesOrder() == 1);
        this.sortSearchesDescendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortSearchesComposite, (String)Messages.getString("BrowserSorterDialog.Descending"), (int)1);
        this.sortSearchesDescendingButton.setSelection(this.preferences.getSortSearchesOrder() == 2);
        this.sortSearchesNoSortingButton = BaseWidgetUtils.createRadiobutton((Composite)sortSearchesComposite, (String)Messages.getString("BrowserSorterDialog.NoSorting"), (int)1);
        this.sortSearchesNoSortingButton.setSelection(this.preferences.getSortSearchesOrder() == 0);
    }

    private void createSortBookmarksGroup(Composite parent) {
        Group sortBookmarksGroup = BaseWidgetUtils.createGroup((Composite)parent, (String)Messages.getString("BrowserSorterDialog.SortBookmarks"), (int)1);
        Composite sortBookmarksComposite = BaseWidgetUtils.createColumnContainer((Composite)sortBookmarksGroup, (int)3, (int)1);
        this.sortBookmarksAscendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortBookmarksComposite, (String)Messages.getString("BrowserSorterDialog.Ascending"), (int)1);
        this.sortBookmarksAscendingButton.setSelection(this.preferences.getSortBookmarksOrder() == 1);
        this.sortBookmarksDescendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortBookmarksComposite, (String)Messages.getString("BrowserSorterDialog.Descending"), (int)1);
        this.sortBookmarksDescendingButton.setSelection(this.preferences.getSortBookmarksOrder() == 2);
        this.sortBookmarksNoSortingButton = BaseWidgetUtils.createRadiobutton((Composite)sortBookmarksComposite, (String)Messages.getString("BrowserSorterDialog.NoSorting"), (int)1);
        this.sortBookmarksNoSortingButton.setSelection(this.preferences.getSortBookmarksOrder() == 0);
    }

    private void createSortLimitGroup(Composite composite) {
        Group sortLimitGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserSorterDialog.SortLimit"), (int)1);
        Composite sortLimitComposite = BaseWidgetUtils.createColumnContainer((Composite)sortLimitGroup, (int)2, (int)1);
        String sortLimitTooltip = Messages.getString("BrowserSorterDialog.SortLimitToolTip");
        Label sortLimitLabel = BaseWidgetUtils.createLabel((Composite)sortLimitComposite, (String)Messages.getString("BrowserSorterDialog.SortLimitColon"), (int)1);
        sortLimitLabel.setToolTipText(sortLimitTooltip);
        this.sortLimitText = BaseWidgetUtils.createText((Composite)sortLimitComposite, (String)("" + this.preferences.getSortLimit()), (int)5, (int)1);
        this.sortLimitText.setToolTipText(sortLimitTooltip);
        this.sortLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
    }
}

