/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.jface.resource.ImageDescriptor;

public class RefreshAction
extends BrowserAction {
    @Override
    public String getText() {
        List<IEntry> entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IEntry entryInput = this.getEntryInput();
        ISearch searchInput = this.getSearchInput();
        if (entries.size() > 0 && searches.length == 0 && entryInput == null && searchInput == null) {
            return entries.size() == 1 ? Messages.getString("RefreshAction.ReloadEntry") : Messages.getString("RefreshAction.ReloadEntries");
        }
        if (searches.length > 0 && entries.size() == 0 && entryInput == null && searchInput == null) {
            boolean searchAgain = true;
            int i = 0;
            while (i < searches.length) {
                if (searches[i].getSearchResults() == null) {
                    searchAgain = false;
                    break;
                }
                ++i;
            }
            if (searchAgain) {
                return Messages.getString("RefreshAction.SearchAgain");
            }
            return searches.length == 1 ? Messages.getString("RefreshAction.PerformSearch") : Messages.getString("RefreshAction.PerformSearches");
        }
        if (entryInput != null && searches.length == 0 && entries.size() == 0 && searchInput == null) {
            return Messages.getString("RefreshAction.RelaodAttributes");
        }
        if (searchInput != null && searches.length == 0 && entryInput == null) {
            return searchInput.getSearchResults() == null ? Messages.getString("RefreshAction.PerformSearch") : Messages.getString("RefreshAction.SearchAgain");
        }
        return Messages.getString("RefreshAction.Refresh");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/refresh.gif");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.file.refresh";
    }

    @Override
    public void run() {
        ISearch search;
        List<IEntry> entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IEntry entryInput = this.getEntryInput();
        ISearch searchInput = this.getSearchInput();
        if (entries.size() > 0) {
            for (IEntry entry : entries) {
                IContinuation continuation;
                if (!(entry instanceof IContinuation) || (continuation = (IContinuation)entry).getState() == IContinuation.State.RESOLVED) continue;
                continuation.resolve();
            }
            InitializeChildrenRunnable initializeChildrenRunnable = new InitializeChildrenRunnable(true, entries.toArray(new IEntry[0]));
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{initializeChildrenRunnable}).execute();
        }
        if (searches.length > 0) {
            ISearch[] iSearchArray = searches;
            int n = searches.length;
            int n2 = 0;
            while (n2 < n) {
                IContinuation continuation;
                search = iSearchArray[n2];
                search.setSearchResults(null);
                if (search instanceof IContinuation && (continuation = (IContinuation)search).getState() != IContinuation.State.RESOLVED) {
                    continuation.resolve();
                }
                ++n2;
            }
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new SearchRunnable(searches)}).execute();
        }
        if (entryInput != null) {
            IEntry entry;
            entry = entryInput.getBrowserConnection().getEntryFromCache(entryInput.getDn());
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new InitializeAttributesRunnable(new IEntry[]{entry})}).execute();
        }
        if (searchInput != null) {
            search = searchInput.getBrowserConnection().getSearchManager().getSearch(searchInput.getName());
            search.setSearchResults(null);
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new SearchRunnable(new ISearch[]{search})}).execute();
        }
    }

    @Override
    public boolean isEnabled() {
        List<IEntry> entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IEntry entryInput = this.getEntryInput();
        ISearch searchInput = this.getSearchInput();
        return entries.size() > 0 || searches.length > 0 || entryInput != null || searchInput != null;
    }

    protected List<IEntry> getEntries() {
        ArrayList<IEntry> entries = new ArrayList<IEntry>();
        entries.addAll(Arrays.asList(this.getSelectedEntries()));
        ISearchResult[] iSearchResultArray = this.getSelectedSearchResults();
        int n = iSearchResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchResult searchResult = iSearchResultArray[n2];
            entries.add(searchResult.getEntry());
            ++n2;
        }
        iSearchResultArray = this.getSelectedBookmarks();
        n = iSearchResultArray.length;
        n2 = 0;
        while (n2 < n) {
            ISearchResult bookmark = iSearchResultArray[n2];
            entries.add(bookmark.getEntry());
            ++n2;
        }
        return entries;
    }

    protected ISearch[] getSearches() {
        return this.getSelectedSearches();
    }

    private IEntry getEntryInput() {
        if (this.getInput() instanceof IEntry) {
            return (IEntry)this.getInput();
        }
        return null;
    }

    private ISearch getSearchInput() {
        if (this.getInput() instanceof ISearch) {
            return (ISearch)this.getInput();
        }
        return null;
    }
}

