/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import org.apache.directory.studio.connection.ui.widgets.ConnectionContentProvider;
import org.apache.directory.studio.connection.ui.widgets.ConnectionLabelProvider;
import org.apache.directory.studio.connection.ui.widgets.ConnectionSorter;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Menu;

public class ConnectionConfiguration {
    private boolean disposed = false;
    private ConnectionContentProvider contentProvider;
    private ConnectionLabelProvider labelProvider;
    private ConnectionSorter sorter;
    private MenuManager contextMenuManager;

    public void dispose() {
        if (!this.disposed) {
            if (this.contentProvider != null) {
                this.contentProvider.dispose();
                this.contentProvider = null;
            }
            if (this.labelProvider != null) {
                this.labelProvider.dispose();
                this.labelProvider = null;
            }
            if (this.contextMenuManager != null) {
                this.contextMenuManager.dispose();
                this.contextMenuManager = null;
            }
            this.disposed = true;
        }
    }

    public IMenuManager getContextMenuManager(TreeViewer viewer) {
        if (this.contextMenuManager == null) {
            this.contextMenuManager = new MenuManager();
            Menu menu = this.contextMenuManager.createContextMenu(viewer.getControl());
            viewer.getControl().setMenu(menu);
        }
        return this.contextMenuManager;
    }

    public ConnectionContentProvider getContentProvider(TreeViewer viewer) {
        if (this.contentProvider == null) {
            this.contentProvider = new ConnectionContentProvider();
        }
        return this.contentProvider;
    }

    public ConnectionLabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.labelProvider == null) {
            this.labelProvider = new ConnectionLabelProvider();
        }
        return this.labelProvider;
    }

    public ConnectionSorter getSorter() {
        if (this.sorter == null) {
            this.sorter = new ConnectionSorter();
        }
        return this.sorter;
    }
}

