/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.common.ui.ClipboardUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionFolderManager;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.ui.actions.Messages;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.apache.directory.studio.connection.ui.dnd.ConnectionTransfer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class PasteAction
extends StudioAction {
    @Override
    public String getText() {
        List<Connection> connections = this.getConnectionsToPaste();
        List<ConnectionFolder> connectionFolders = this.getConnectionFoldersToPaste();
        if (!connections.isEmpty() && connectionFolders.isEmpty()) {
            if (connections.size() > 1) {
                return Messages.getString("PasteAction.PasteConnections");
            }
            return Messages.getString("PasteAction.PasteConnection");
        }
        if (!connectionFolders.isEmpty() && connections.isEmpty()) {
            if (connectionFolders.size() > 1) {
                return Messages.getString("PasteAction.PasteConnectionFolders");
            }
            return Messages.getString("PasteAction.PasteConnectionFolder");
        }
        return Messages.getString("PasteAction.Paste");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.paste";
    }

    @Override
    public boolean isEnabled() {
        return ClipboardUtils.isAvailable((Transfer)ConnectionTransfer.getInstance());
    }

    @Override
    public void run() {
        ConnectionFolderManager connectionFolderManager = ConnectionCorePlugin.getDefault().getConnectionFolderManager();
        ConnectionManager connectionManager = ConnectionCorePlugin.getDefault().getConnectionManager();
        ConnectionFolder[] selectedFolders = this.getSelectedConnectionFolders();
        Connection[] selectedConnections = this.getSelectedConnections();
        ConnectionFolder targetFolder = null;
        if (selectedFolders.length > 0) {
            targetFolder = selectedFolders[0];
        } else if (selectedConnections.length > 0) {
            targetFolder = connectionFolderManager.getParentConnectionFolder(selectedConnections[0]);
        }
        if (targetFolder == null) {
            targetFolder = connectionFolderManager.getRootConnectionFolder();
        }
        List<Connection> connections = this.getConnectionsToPaste();
        for (Connection connection : connections) {
            Connection newConnection = (Connection)connection.clone();
            connectionManager.addConnection(newConnection);
            targetFolder.addConnectionId(newConnection.getId());
        }
        List<ConnectionFolder> connectionFolders = this.getConnectionFoldersToPaste();
        for (ConnectionFolder connectionFolder : connectionFolders) {
            ConnectionFolder newConnectionFolder = (ConnectionFolder)connectionFolder.clone();
            connectionFolderManager.addConnectionFolder(newConnectionFolder);
            targetFolder.addSubFolderId(newConnectionFolder.getId());
        }
    }

    private List<Connection> getConnectionsToPaste() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Object content = ClipboardUtils.getFromClipboard((Transfer)ConnectionTransfer.getInstance());
        if (content instanceof Object[]) {
            Object[] objectArray = (Object[])content;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Connection) {
                    connections.add((Connection)object);
                }
                ++n2;
            }
        }
        return connections;
    }

    private List<ConnectionFolder> getConnectionFoldersToPaste() {
        ArrayList<ConnectionFolder> folders = new ArrayList<ConnectionFolder>();
        Object content = ClipboardUtils.getFromClipboard((Transfer)ConnectionTransfer.getInstance());
        if (content instanceof Object[]) {
            Object[] objectArray = (Object[])content;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ConnectionFolder) {
                    folders.add((ConnectionFolder)object);
                }
                ++n2;
            }
        }
        return folders;
    }
}

