/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.common.ui.ClipboardUtils;
import org.apache.directory.studio.ldapbrowser.common.actions.PasteAction;
import org.apache.directory.studio.ldapbrowser.common.dnd.ValuesTransfer;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.Messages;
import org.eclipse.swt.dnd.Transfer;

public class SearchResultEditorPasteAction
extends PasteAction {
    public String getText() {
        IValue[] values = this.getValuesToPaste();
        if (values != null) {
            return values.length > 1 ? Messages.getString("SearchResultEditorPasteAction.PasteValues") : Messages.getString("SearchResultEditorPasteAction.PasteValue");
        }
        return Messages.getString("SearchResultEditorPasteAction.Paste");
    }

    public boolean isEnabled() {
        return this.getValuesToPaste() != null;
    }

    public void run() {
        IValue[] values = this.getValuesToPaste();
        if (values != null) {
            IAttribute attribute = this.getSelectedAttributeHierarchies()[0].getAttribute();
            IEntry entry = attribute.getEntry();
            IValue[] newValues = new IValue[values.length];
            int v = 0;
            while (v < values.length) {
                newValues[v] = new Value(attribute, values[v].getRawValue());
                ++v;
            }
            new CompoundModification().createValues(entry, newValues);
        }
    }

    private IValue[] getValuesToPaste() {
        Object content;
        if (this.getSelectedEntries().length + this.getSelectedBookmarks().length + this.getSelectedValues().length + this.getSelectedAttributes().length + this.getSelectedSearches().length == 0 && this.getSelectedSearchResults().length == 1 && this.getSelectedAttributeHierarchies().length == 1 && this.getSelectedAttributeHierarchies()[0].size() == 1 && (content = ClipboardUtils.getFromClipboard((Transfer)ValuesTransfer.getInstance())) instanceof IValue[]) {
            IValue[] values = (IValue[])content;
            return values;
        }
        return null;
    }
}

