/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyEntryAsAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;

public class CopyEntryAsCsvAction
extends CopyEntryAsAction {
    public static final int MODE_TABLE = 5;

    public CopyEntryAsCsvAction(int mode) {
        super(Messages.getString("CopyEntryAsCsvAction.CSV"), mode);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.mode == 1) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv.gif");
        }
        if (this.mode == 2) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv_searchresult.gif");
        }
        if (this.mode == 4) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv_operational.gif");
        }
        if (this.mode == 3) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv_user.gif");
        }
        if (this.mode == 5) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_table.gif");
        }
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv.gif");
    }

    @Override
    public String getText() {
        if (this.mode == 5) {
            return Messages.getString("CopyEntryAsCsvAction.CopyTable");
        }
        return super.getText();
    }

    @Override
    public boolean isEnabled() {
        if (this.mode == 5) {
            return this.getInput() instanceof ISearch && ((ISearch)this.getInput()).getSearchResults() != null && ((ISearch)this.getInput()).getSearchResults().length > 0;
        }
        return super.isEnabled();
    }

    @Override
    public void run() {
        if (this.mode == 5) {
            if (this.getInput() instanceof ISearch && ((ISearch)this.getInput()).getSearchResults() != null && ((ISearch)this.getInput()).getSearchResults().length > 0) {
                ArrayList<IEntry> entryList = new ArrayList<IEntry>();
                ISearchResult[] results = ((ISearch)this.getInput()).getSearchResults();
                int k = 0;
                while (k < results.length) {
                    entryList.add(results[k].getEntry());
                    ++k;
                }
                IEntry[] entries = entryList.toArray(new IEntry[entryList.size()]);
                StringBuffer text = new StringBuffer();
                this.serialializeEntries(entries, text);
                this.copyToClipboard(text.toString());
            }
        } else {
            super.run();
        }
    }

    @Override
    public void serialializeEntries(IEntry[] entries, StringBuffer text) {
        String attributeDelimiter = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableAttributeDelimiter");
        String valueDelimiter = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableValueDelimiter");
        String quoteCharacter = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableQuoteCharacter");
        String lineSeparator = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableLineSeparator");
        int binaryEncoding = BrowserCommonActivator.getDefault().getPreferenceStore().getInt("formatTableBinaryEncoding");
        String[] returningAttributes = null;
        if (this.mode == 1) {
            returningAttributes = new String[]{};
        } else if (this.mode == 2 && this.getSelectedSearchResults().length > 0 && this.getSelectedEntries().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length == 0) {
            returningAttributes = this.getSelectedSearchResults()[0].getSearch().getReturningAttributes();
        } else if ((this.mode == 2 || this.mode == 5) && this.getSelectedSearches().length == 1) {
            returningAttributes = this.getSelectedSearches()[0].getReturningAttributes();
        } else if ((this.mode == 2 || this.mode == 5) && this.getInput() instanceof ISearch) {
            returningAttributes = ((ISearch)this.getInput()).getReturningAttributes();
        } else {
            HashMap<String, IAttribute> attributeMap = new HashMap<String, IAttribute>();
            int e = 0;
            while (entries != null && e < entries.length) {
                IAttribute[] attributes = entries[e].getAttributes();
                int a = 0;
                while (attributes != null && a < attributes.length) {
                    if (!(attributes[a].isOperationalAttribute() && this.mode != 4 || attributeMap.containsKey(attributes[a].getDescription()))) {
                        attributeMap.put(attributes[a].getDescription(), attributes[a]);
                    }
                    ++a;
                }
                ++e;
            }
            IAttribute[] attributes = attributeMap.values().toArray(new IAttribute[attributeMap.size()]);
            if (attributes.length > 0) {
                AttributeComparator comparator = new AttributeComparator();
                Arrays.sort(attributes, comparator);
            }
            returningAttributes = new String[attributes.length];
            int i = 0;
            while (i < attributes.length) {
                returningAttributes[i] = attributes[i].getDescription();
                ++i;
            }
        }
        if (this.mode != 5 || BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("searchResultEditorShowDn")) {
            text.append(quoteCharacter);
            text.append("Dn");
            text.append(quoteCharacter);
            text.append(attributeDelimiter);
        }
        int a = 0;
        while (returningAttributes != null && a < returningAttributes.length) {
            text.append(quoteCharacter);
            text.append(returningAttributes[a]);
            text.append(quoteCharacter);
            if (a + 1 < returningAttributes.length) {
                text.append(attributeDelimiter);
            }
            ++a;
        }
        text.append(lineSeparator);
        int e = 0;
        while (entries != null && e < entries.length) {
            if (this.mode != 5 || BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("searchResultEditorShowDn")) {
                text.append(quoteCharacter);
                text.append(entries[e].getDn().getName());
                text.append(quoteCharacter);
                text.append(attributeDelimiter);
            }
            int a2 = 0;
            while (returningAttributes != null && a2 < returningAttributes.length) {
                AttributeComparator comparator = new AttributeComparator();
                AttributeHierarchy ah = entries[e].getAttributeWithSubtypes(returningAttributes[a2]);
                if (ah != null) {
                    StringBuffer valueSB = new StringBuffer();
                    Iterator it = ah.iterator();
                    while (it.hasNext()) {
                        IAttribute attribute = (IAttribute)it.next();
                        if (attribute != null) {
                            IValue[] values = attribute.getValues();
                            Arrays.sort(values, comparator);
                            int v = 0;
                            while (v < values.length) {
                                String val = ModelConverter.getStringValue((IValue)values[v], (int)binaryEncoding);
                                valueSB.append(val);
                                if (v + 1 < values.length) {
                                    valueSB.append(valueDelimiter);
                                }
                                ++v;
                            }
                        }
                        if (!it.hasNext()) continue;
                        valueSB.append(valueDelimiter);
                    }
                    String value = valueSB.toString().replaceAll(quoteCharacter, String.valueOf(quoteCharacter) + quoteCharacter);
                    text.append(quoteCharacter);
                    text.append(value);
                    text.append(quoteCharacter);
                }
                if (a2 + 1 < returningAttributes.length) {
                    text.append(attributeDelimiter);
                }
                ++a2;
            }
            if (e < entries.length) {
                text.append(lineSeparator);
            }
            ++e;
        }
    }
}

