/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.List;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;

public class ReadEntryRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;
    private Dn dn;
    private IEntry readEntry;

    public ReadEntryRunnable(IBrowserConnection browserConnection, Dn dn) {
        this.browserConnection = browserConnection;
        this.dn = dn;
        this.readEntry = null;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__read_entry_name;
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.browserConnection};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__read_entry_error;
    }

    public void run(StudioProgressMonitor pm) {
        this.readEntry = this.browserConnection.getEntryFromCache(this.dn);
        if (this.readEntry == null) {
            pm.beginTask(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__read_entry_task, (Object[])new String[]{this.dn.toString()}), 2);
            pm.reportProgress(" ");
            pm.worked(1);
            this.readEntry = ReadEntryRunnable.getEntry(this.browserConnection, this.dn, null, pm);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
    }

    static IEntry getEntry(IBrowserConnection browserConnection, Dn dn, List<Control> controls, StudioProgressMonitor monitor) {
        try {
            IEntry entry = browserConnection.getEntryFromCache(dn);
            if (entry != null) {
                return entry;
            }
            Search search = new Search(null, browserConnection, dn, null, ISearch.NO_ATTRIBUTES, SearchScope.OBJECT, 1, 0, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, true, controls, false);
            SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
            ISearchResult[] srs = search.getSearchResults();
            if (srs.length > 0) {
                return srs[0].getEntry();
            }
            monitor.reportError(BrowserCoreMessages.bind((String)BrowserCoreMessages.model__no_such_entry, (Object)dn));
            return null;
        }
        catch (Exception e) {
            monitor.reportError(e);
            return null;
        }
    }

    public IEntry getReadEntry() {
        return this.readEntry;
    }
}

