/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.StringValueEditorUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;

public abstract class AbstractInPlaceStringValueEditor
extends TextCellEditor
implements IValueEditor {
    private String name;
    private ImageDescriptor imageDescriptor;

    protected AbstractInPlaceStringValueEditor() {
    }

    protected boolean showRawValues() {
        return BrowserCommonActivator.getDefault().getPreferenceStore().getBoolean("showRawValues");
    }

    @Override
    public String getDisplayValue(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        ArrayList<IValue> valueList = new ArrayList<IValue>();
        for (IAttribute attribute : attributeHierarchy) {
            valueList.addAll(Arrays.asList(attribute.getValues()));
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (IValue value : valueList) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.getDisplayValue(value));
        }
        return sb.toString();
    }

    @Override
    public String getDisplayValue(IValue value) {
        Object obj = this.getRawValue(value);
        return StringValueEditorUtils.getDisplayValue(obj);
    }

    @Override
    public Object getRawValue(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy != null && attributeHierarchy.size() == 1) {
            if (attributeHierarchy.getAttribute().getValueSize() == 0) {
                if (attributeHierarchy.getAttribute().isString()) {
                    return IValue.EMPTY_STRING_VALUE;
                }
                return IValue.EMPTY_BINARY_VALUE;
            }
            if (attributeHierarchy.getAttribute().getValueSize() == 1) {
                return this.getRawValue(attributeHierarchy.getAttribute().getValues()[0]);
            }
        }
        return null;
    }

    @Override
    public boolean hasValue(IValue value) {
        return value != null && (value.isString() || value.isBinary());
    }

    @Override
    public Object getRawValue(IValue value) {
        return StringValueEditorUtils.getRawValue(value);
    }

    @Override
    public Object getStringOrBinaryValue(Object rawValue) {
        return StringValueEditorUtils.getStringOrBinaryValue(rawValue);
    }

    @Override
    public CellEditor getCellEditor() {
        return this;
    }

    protected Object doGetValue() {
        if ("".equals(this.text.getText())) {
            return null;
        }
        return this.text.getText();
    }

    protected void doSetValue(Object value) {
        if (value instanceof IValue.EmptyValue) {
            super.doSetValue((Object)((IValue.EmptyValue)value).getStringValue());
        } else {
            super.doSetValue(value);
        }
    }

    @Override
    public void setValueEditorName(String name) {
        this.name = name;
    }

    @Override
    public String getValueEditorName() {
        return this.name;
    }

    @Override
    public void setValueEditorImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    @Override
    public ImageDescriptor getValueEditorImageDescriptor() {
        return this.imageDescriptor;
    }
}

