/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;

public class LdapFilterItemComponent
extends LdapFilterComponent {
    private LdapFilterToken filtertypeToken = null;
    private LdapFilterToken valueToken = null;

    public LdapFilterItemComponent(LdapFilter parent) {
        super(parent);
    }

    @Override
    public boolean setStartToken(LdapFilterToken attributeToken) {
        if (attributeToken != null && attributeToken.getType() == 31) {
            super.setStartToken(attributeToken);
            return true;
        }
        return false;
    }

    public boolean setAttributeToken(LdapFilterToken attributeToken) {
        return this.setStartToken(attributeToken);
    }

    public LdapFilterToken getAttributeToken() {
        return this.getStartToken();
    }

    public boolean setFiltertypeToken(LdapFilterToken filtertypeToken) {
        if (this.filtertypeToken == null && filtertypeToken != null && (filtertypeToken.getType() == 41 || filtertypeToken.getType() == 43 || filtertypeToken.getType() == 44 || filtertypeToken.getType() == 42 || filtertypeToken.getType() == 45 || filtertypeToken.getType() == 46)) {
            this.filtertypeToken = filtertypeToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getFilterToken() {
        return this.filtertypeToken;
    }

    public boolean setValueToken(LdapFilterToken valueToken) {
        if (this.valueToken == null && valueToken != null && valueToken.getType() == 51) {
            this.valueToken = valueToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getValueToken() {
        return this.valueToken;
    }

    @Override
    public boolean isValid() {
        return this.startToken != null && this.filtertypeToken != null && (this.valueToken != null || this.filtertypeToken.getType() == 45);
    }

    @Override
    public LdapFilterToken[] getTokens() {
        ArrayList<LdapFilterToken> tokenList = new ArrayList<LdapFilterToken>();
        if (this.startToken != null) {
            tokenList.add(this.startToken);
        }
        if (this.filtertypeToken != null) {
            tokenList.add(this.filtertypeToken);
        }
        if (this.valueToken != null) {
            tokenList.add(this.valueToken);
        }
        Object[] tokens = tokenList.toArray(new LdapFilterToken[tokenList.size()]);
        Arrays.sort(tokens);
        return tokens;
    }

    public String toString() {
        return String.valueOf(this.startToken != null ? this.startToken.getValue() : "") + (this.filtertypeToken != null ? this.filtertypeToken.getValue() : "") + (this.valueToken != null ? this.valueToken.getValue() : "");
    }

    @Override
    public boolean addFilter(LdapFilter filter) {
        return false;
    }

    @Override
    public LdapFilter[] getInvalidFilters() {
        if (this.isValid()) {
            return new LdapFilter[0];
        }
        return new LdapFilter[]{this.parent};
    }

    @Override
    public LdapFilter getFilter(int offset) {
        if (this.startToken != null && this.startToken.getOffset() <= offset && offset < this.startToken.getOffset() + this.startToken.getLength()) {
            return this.parent;
        }
        if (this.filtertypeToken != null && this.filtertypeToken.getOffset() <= offset && offset < this.filtertypeToken.getOffset() + this.filtertypeToken.getLength()) {
            return this.parent;
        }
        if (this.valueToken != null && this.valueToken.getOffset() <= offset && offset < this.valueToken.getOffset() + this.valueToken.getLength()) {
            return this.parent;
        }
        return null;
    }

    @Override
    public String getInvalidCause() {
        if (this.startToken == null) {
            return Messages.LdapFilterItemComponent_MissingAttributeName;
        }
        if (this.filtertypeToken == null) {
            return Messages.LdapFilterItemComponent_MissingFilterType;
        }
        if (this.valueToken == null) {
            return Messages.LdapFilterItemComponent_MissingValue;
        }
        return null;
    }
}

