/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResultEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifVersionLine;

public class ExportLdifRunnable
implements StudioConnectionRunnableWithProgress {
    private String exportLdifFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;

    public ExportLdifRunnable(String exportLdifFilename, IBrowserConnection browserConnection, SearchParameter searchParameter) {
        this.exportLdifFilename = exportLdifFilename;
        this.browserConnection = browserConnection;
        this.searchParameter = searchParameter;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__export_ldif_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportLdifFilename));
        return l.toArray();
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_ldif_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_ldif_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            FileWriter fileWriter = new FileWriter(this.exportLdifFilename);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int count = 0;
            ExportLdifRunnable.export(this.browserConnection, this.searchParameter, bufferedWriter, count, monitor);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private static void export(IBrowserConnection browserConnection, SearchParameter searchParameter, BufferedWriter bufferedWriter, int count, StudioProgressMonitor monitor) throws IOException {
        block5: {
            try {
                LdifEnumeration enumeration = ExportLdifRunnable.search(browserConnection, searchParameter, monitor);
                LdifFormatParameters ldifFormatParameters = Utils.getLdifFormatParameters();
                if (BrowserCorePlugin.getDefault().getPluginPreferences().getBoolean("ldifIncludeVersionLine")) {
                    LdifVersionLine ldifVersionLine = LdifVersionLine.create();
                    String ldifVersionLineString = ldifVersionLine.toFormattedString(ldifFormatParameters);
                    bufferedWriter.write(ldifVersionLineString);
                    LdifSepLine ldifSepLine = LdifSepLine.create();
                    String ldifSepLineString = ldifSepLine.toFormattedString(ldifFormatParameters);
                    bufferedWriter.write(ldifSepLineString);
                }
                while (!monitor.isCanceled() && !monitor.errorsReported() && enumeration.hasNext()) {
                    LdifContainer container = enumeration.next();
                    if (!(container instanceof LdifContentRecord)) continue;
                    LdifContentRecord record = (LdifContentRecord)container;
                    LdifDnLine dnLine = record.getDnLine();
                    LdifSepLine sepLine = record.getSepLine();
                    DummyEntry entry = ModelConverter.ldifContentRecordToEntry(record, browserConnection);
                    List<IValue> sortedValues = AttributeComparator.toSortedValues(entry);
                    LdifContentRecord newRecord = new LdifContentRecord(dnLine);
                    for (IValue value : sortedValues) {
                        newRecord.addAttrVal(ModelConverter.valueToLdifAttrValLine(value));
                    }
                    newRecord.finish(sepLine);
                    String s = newRecord.toFormattedString(ldifFormatParameters);
                    bufferedWriter.write(s);
                    monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
                }
            }
            catch (LdapException loe) {
                int ldapStatusCode = JNDIUtils.getLdapStatusCode((Exception)((Object)loe));
                if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) break block5;
                monitor.reportError((Exception)((Object)loe));
            }
        }
    }

    static LdifEnumeration search(IBrowserConnection browserConnection, SearchParameter parameter, StudioProgressMonitor monitor) {
        StudioSearchResultEnumeration result = SearchRunnable.search(browserConnection, parameter, monitor);
        return new DefaultLdifEnumeration(result, browserConnection, parameter, monitor);
    }

    static class DefaultLdifEnumeration
    implements LdifEnumeration {
        private StudioSearchResultEnumeration enumeration;
        private IBrowserConnection browserConnection;
        private SearchParameter parameter;
        private StudioProgressMonitor monitor;

        public DefaultLdifEnumeration(StudioSearchResultEnumeration enumeration, IBrowserConnection browserConnection, SearchParameter parameter, StudioProgressMonitor monitor) {
            this.enumeration = enumeration;
            this.browserConnection = browserConnection;
            this.parameter = parameter;
            this.monitor = monitor;
        }

        public boolean hasNext() throws LdapException {
            if (this.enumeration != null) {
                if (this.enumeration.hasMore()) {
                    return true;
                }
                for (Control responseControl : this.enumeration.getResponseControls()) {
                    PagedResults prc;
                    if (!(responseControl instanceof PagedResults) || !ArrayUtils.isNotEmpty((byte[])(prc = (PagedResults)responseControl).getCookie())) continue;
                    byte[] cookie = prc.getCookie();
                    for (Control requestControl : this.parameter.getControls()) {
                        if (!(requestControl instanceof PagedResults)) continue;
                        ((PagedResults)requestControl).setCookie(cookie);
                    }
                    this.enumeration = SearchRunnable.search(this.browserConnection, this.parameter, this.monitor);
                    return this.enumeration != null && this.enumeration.hasMore();
                }
            }
            return false;
        }

        public LdifContainer next() throws LdapException {
            Entry entry = this.enumeration.next().getEntry();
            Dn dn = entry.getDn();
            LdifContentRecord record = LdifContentRecord.create((String)dn.getName());
            for (Attribute attribute : entry) {
                String attributeName = attribute.getUpId();
                for (Value value : attribute) {
                    if (value.isHumanReadable()) {
                        record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)value.getString()));
                        continue;
                    }
                    record.addAttrVal(LdifAttrValLine.create((String)attributeName, (byte[])value.getBytes()));
                }
            }
            record.finish(LdifSepLine.create());
            return record;
        }
    }
}

