/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.core.jobs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.studio.common.core.jobs.CommonCoreConstants;
import org.apache.directory.studio.common.core.jobs.CommonCorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;

public class StudioProgressMonitor
extends ProgressMonitorWrapper {
    protected String pluginId;
    protected boolean isDone;
    protected List<Status> errorStatusList;
    protected List<CancelListener> cancelListenerList;
    protected AtomicBoolean allowMessageReporting;

    public StudioProgressMonitor(IProgressMonitor monitor) {
        this(CommonCoreConstants.PLUGIN_ID, monitor);
    }

    public StudioProgressMonitor(String pluginId, IProgressMonitor monitor) {
        super(monitor);
        this.pluginId = pluginId;
        this.isDone = false;
        CommonCorePlugin.getDefault().getStudioProgressMonitorWatcherJob().addMonitor(this);
        this.allowMessageReporting = new AtomicBoolean(true);
    }

    public void setCanceled(boolean canceled) {
        super.setCanceled(canceled);
        if (canceled) {
            this.fireCancelRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        StudioProgressMonitor studioProgressMonitor = this;
        synchronized (studioProgressMonitor) {
            this.isDone = true;
            super.done();
        }
    }

    public void addCancelListener(CancelListener listener) {
        if (this.cancelListenerList == null) {
            this.cancelListenerList = new ArrayList<CancelListener>();
        }
        if (!this.cancelListenerList.contains(listener)) {
            this.cancelListenerList.add(listener);
        }
    }

    public void removeCancelListener(CancelListener listener) {
        if (this.cancelListenerList != null && this.cancelListenerList.contains(listener)) {
            this.cancelListenerList.remove(listener);
        }
    }

    void fireCancelRequested() {
        CancelEvent event = new CancelEvent((IProgressMonitor)this);
        if (this.cancelListenerList != null) {
            for (CancelListener cancelListener : this.cancelListenerList) {
                cancelListener.cancelRequested(event);
            }
        }
    }

    public void reportProgress(String message) {
        boolean doReport = this.allowMessageReporting.getAndSet(false);
        if (doReport) {
            this.subTask(message);
        }
    }

    public void reportError(String message) {
        this.reportError(message, null);
    }

    public void reportError(Exception exception) {
        this.reportError(null, exception);
    }

    public void reportError(String message, Exception exception) {
        if (this.errorStatusList == null) {
            this.errorStatusList = new ArrayList<Status>(3);
        }
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, this.pluginId, 4, message, (Throwable)exception);
        this.errorStatusList.add(errorStatus);
    }

    public boolean errorsReported() {
        return this.errorStatusList != null;
    }

    public IStatus getErrorStatus(String message) {
        if (this.errorStatusList == null || this.errorStatusList.isEmpty()) {
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(message);
        for (Status status : this.errorStatusList) {
            String statusMessage = status.getMessage();
            Throwable exception = status.getException();
            String exceptionMessage = null;
            if (exception != null) {
                exceptionMessage = exception.getMessage();
            }
            if (!StringUtils.isEmpty((CharSequence)statusMessage)) {
                buffer.append("\n - ").append(statusMessage);
            }
            if (exception == null || exceptionMessage == null || exceptionMessage.equals(statusMessage)) continue;
            int indexOfAny = StringUtils.indexOfAny((CharSequence)exceptionMessage, (String)"\n\r\t");
            if (indexOfAny > -1) {
                exceptionMessage = exceptionMessage.substring(0, indexOfAny);
            }
            buffer.append("\n - ").append(exceptionMessage);
        }
        MultiStatus multiStatus = new MultiStatus(this.pluginId, 4, buffer.toString(), null);
        for (Status status : this.errorStatusList) {
            String statusMessage = status.getMessage();
            if (status.getException() != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                status.getException().printStackTrace(printWriter);
                statusMessage = stringWriter.toString();
            }
            multiStatus.add((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), statusMessage, status.getException()));
        }
        return multiStatus;
    }

    public Exception getException() {
        if (this.errorStatusList != null) {
            return (Exception)this.errorStatusList.get(0).getException();
        }
        return null;
    }

    public void reset() {
        this.isDone = false;
        this.errorStatusList = null;
    }

    public static class CancelEvent {
        private IProgressMonitor monitor;

        public CancelEvent(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public IProgressMonitor getMonitor() {
            return this.monitor;
        }
    }

    public static interface CancelListener {
        public void cancelRequested(CancelEvent var1);
    }
}

