/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.wizards.ExportProjectsWizard;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ExportProjectsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TableViewer viewer;

    public ExportProjectsAction(TableViewer viewer) {
        super(Messages.getString("ExportProjectsAction.SchemaProjectsAction"));
        this.setToolTipText(this.getText());
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/project_export.gif"));
        this.setEnabled(true);
        this.viewer = viewer;
    }

    public void run() {
        ArrayList<Project> selectedProjects = new ArrayList<Project>();
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && selection.size() > 0) {
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                selectedProjects.add(((ProjectWrapper)i.next()).getProject());
            }
        }
        ExportProjectsWizard wizard = new ExportProjectsWizard();
        wizard.setSelectedProjects(selectedProjects.toArray(new Project[0]));
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

