/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui.dialogs;

import org.apache.directory.studio.common.ui.AddEditDialog;
import org.apache.directory.studio.common.ui.Messages;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.wrappers.StringValueWrapper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AttributeDialog
extends AddEditDialog<StringValueWrapper> {
    private String[] attributeTypesAndOids;
    private Combo typeOrOidCombo;

    public AttributeDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setAttributeNamesAndOids(String[] attributeNamesAndOids) {
        this.attributeTypesAndOids = attributeNamesAndOids;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AttributeDialog.SelectAttributeTypeOrOID"));
    }

    protected void okPressed() {
        this.setEditedElement(new StringValueWrapper(this.typeOrOidCombo.getText(), false));
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        String attribute;
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0 && ((attribute = ((StringValueWrapper)this.getEditedElement()).getValue()) == null || attribute.length() == 0)) {
            button.setEnabled(false);
        }
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite c = BaseWidgetUtils.createColumnContainer(composite, 2, 1);
        BaseWidgetUtils.createLabel(c, Messages.getString("AttributeDialog.AttributeTypeOrOID"), 1);
        this.typeOrOidCombo = BaseWidgetUtils.createCombo(c, this.attributeTypesAndOids, -1, 1);
        if (this.getEditedElement() != null) {
            this.typeOrOidCombo.setText(((StringValueWrapper)this.getEditedElement()).getValue());
        }
        this.typeOrOidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeDialog.this.validate();
            }
        });
        this.initDialog();
        return composite;
    }

    @Override
    protected void initDialog() {
    }

    private void validate() {
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        okButton.setEnabled(!"".equals(this.typeOrOidCombo.getText()));
    }

    @Override
    public void addNewElement() {
        this.setEditedElement(new StringValueWrapper("", false));
    }
}

