/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.openldap.accelerator.api.addRole.RbacAddRoleRequestImpl;
import org.openldap.accelerator.api.addRole.RbacAddRoleResponse;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessRequestImpl;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessResponse;
import org.openldap.accelerator.api.createSession.RbacCreateSessionRequestImpl;
import org.openldap.accelerator.api.createSession.RbacCreateSessionResponse;
import org.openldap.accelerator.api.deleteSession.RbacDeleteSessionRequestImpl;
import org.openldap.accelerator.api.deleteSession.RbacDeleteSessionResponse;
import org.openldap.accelerator.api.dropRole.RbacDropRoleRequestImpl;
import org.openldap.accelerator.api.dropRole.RbacDropRoleResponse;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesRequestImpl;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AcceleratorDAO
extends LdapDataProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)AcceleratorDAO.class.getName());

    Session createSession(User user) throws SecurityException {
        Session session;
        block8: {
            session = null;
            LdapConnection ld = null;
            try {
                ld = this.getAdminConnection();
                ld.setTimeOut(0L);
                RbacCreateSessionRequestImpl rbacCreateSessionRequest = new RbacCreateSessionRequestImpl();
                rbacCreateSessionRequest.setTenantId(user.getContextId());
                rbacCreateSessionRequest.setUserIdentity(user.getUserId());
                rbacCreateSessionRequest.setPassword(new String(user.getPassword()));
                if (CollectionUtils.isNotEmpty(user.getRoles())) {
                    for (UserRole userRole : user.getRoles()) {
                        rbacCreateSessionRequest.addRole(userRole.getName());
                    }
                }
                RbacCreateSessionResponse rbacCreateSessionResponse = (RbacCreateSessionResponse)ld.extended((ExtendedRequest)rbacCreateSessionRequest);
                LOG.debug("createSession userId: {}, sessionId: {}, resultCode: {}", new Object[]{user.getUserId(), rbacCreateSessionResponse.getSessionId(), rbacCreateSessionResponse.getLdapResult().getResultCode()});
                session = new Session(user, rbacCreateSessionResponse.getSessionId());
                if (rbacCreateSessionResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                    session.setAuthenticated(true);
                    break block8;
                }
                session.setAuthenticated(false);
                String info = "createSession UserId [" + user.getUserId() + "] failed: " + rbacCreateSessionResponse.getLdapResult() + " , resultCode: " + rbacCreateSessionResponse.getLdapResult().getResultCode().getResultCode();
                throw new SecurityException(1013, info);
            }
            catch (LdapException e) {
                String error = "createSession userId [" + user.getUserId() + "] caught LDAPException= msg=" + e.getMessage();
                throw new SecurityException(10201, error, (Exception)((Object)e));
            }
            finally {
                this.closeAdminConnection(ld);
            }
        }
        return session;
    }

    boolean checkAccess(Session session, Permission perm) throws SecurityException {
        boolean result = false;
        LdapConnection ld = null;
        try {
            ld = this.getAdminConnection();
            RbacCheckAccessRequestImpl rbacCheckAccessRequest = new RbacCheckAccessRequestImpl();
            rbacCheckAccessRequest.setSessionId(session.getSessionId());
            rbacCheckAccessRequest.setObject(perm.getObjName());
            if (StringUtils.isNotEmpty((String)perm.getObjId())) {
                rbacCheckAccessRequest.setObjectId(perm.getObjId());
            }
            rbacCheckAccessRequest.setOperation(perm.getOpName());
            RbacCheckAccessResponse rbacCheckAccessResponse = (RbacCheckAccessResponse)ld.extended((ExtendedRequest)rbacCheckAccessRequest);
            LOG.debug("checkAccess result: {}", (Object)rbacCheckAccessResponse.getLdapResult().getResultCode());
            result = rbacCheckAccessResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS;
        }
        catch (LdapException e) {
            String error = "checkAccess perm obj [" + perm.getObjName() + "], operation [" + perm.getOpName() + "] caught LDAPException= msg=" + e.getMessage();
            throw new SecurityException(10203, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return result;
    }

    void dropActiveRole(Session session, UserRole userRole) throws SecurityException {
        LdapConnection ld = null;
        try {
            ld = this.getAdminConnection();
            RbacDropRoleRequestImpl dropRoleRequest = new RbacDropRoleRequestImpl();
            dropRoleRequest.setSessionId(session.getSessionId());
            dropRoleRequest.setRole(userRole.getName());
            dropRoleRequest.setUserIdentity(userRole.getUserId());
            RbacDropRoleResponse rbacDropRoleResponse = (RbacDropRoleResponse)ld.extended((ExtendedRequest)dropRoleRequest);
            LOG.debug("dropActiveRole result: {}", (Object)rbacDropRoleResponse.getLdapResult().getResultCode());
            if (rbacDropRoleResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
                String info = "dropActiveRole Role [" + userRole.getName() + "] User [" + session.getUserId() + "], not previously activated.";
                throw new SecurityException(2022, info);
            }
        }
        catch (LdapException e) {
            String error = "dropActiveRole role name [" + userRole.getName() + "] caught LDAPException= msg=" + e.getMessage();
            throw new SecurityException(10205, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    void addActiveRole(Session session, UserRole userRole) throws SecurityException {
        LdapConnection ld = null;
        try {
            ld = this.getAdminConnection();
            RbacAddRoleRequestImpl addRoleRequest = new RbacAddRoleRequestImpl();
            addRoleRequest.setSessionId(session.getSessionId());
            addRoleRequest.setRole(userRole.getName());
            addRoleRequest.setUserIdentity(userRole.getUserId());
            RbacAddRoleResponse rbacAddRoleResponse = (RbacAddRoleResponse)ld.extended((ExtendedRequest)addRoleRequest);
            LOG.debug("addActiveRole result: {}", (Object)rbacAddRoleResponse.getLdapResult().getResultCode());
            if (rbacAddRoleResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
                int rc;
                String info;
                if (rbacAddRoleResponse.getLdapResult().getResultCode() == ResultCodeEnum.ATTRIBUTE_OR_VALUE_EXISTS) {
                    info = "addActiveRole Role [" + userRole.getName() + "] User [" + session.getUserId() + "], already activated.";
                    rc = 2011;
                } else {
                    info = "addActiveRole Role [" + userRole.getName() + "] User [" + session.getUserId() + "], not authorized for user.";
                    rc = 2006;
                }
                throw new SecurityException(rc, info);
            }
        }
        catch (LdapException e) {
            String error = "addActiveRole role name [" + userRole.getName() + "] caught LDAPException= msg=" + e.getMessage();
            throw new SecurityException(10204, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    void deleteSession(Session session) throws SecurityException {
        LdapConnection ld = null;
        try {
            ld = this.getAdminConnection();
            RbacDeleteSessionRequestImpl deleteSessionRequest = new RbacDeleteSessionRequestImpl();
            deleteSessionRequest.setSessionId(session.getSessionId());
            deleteSessionRequest.setUserIdentity(session.getUserId());
            RbacDeleteSessionResponse deleteSessionResponse = (RbacDeleteSessionResponse)ld.extended((ExtendedRequest)deleteSessionRequest);
            LOG.debug("deleteSession result: {}", (Object)deleteSessionResponse.getLdapResult().getResultCode());
        }
        catch (LdapException e) {
            String error = "deleteSession caught LDAPException= msg=" + e.getMessage();
            throw new SecurityException(10202, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    List<UserRole> sessionRoles(Session session) throws SecurityException {
        LdapConnection ld = null;
        ArrayList<UserRole> userRoleList = null;
        try {
            ld = this.getAdminConnection();
            RbacSessionRolesRequestImpl sessionRolesRequest = new RbacSessionRolesRequestImpl();
            sessionRolesRequest.setSessionId(session.getSessionId());
            sessionRolesRequest.setUserIdentity(session.getUserId());
            RbacSessionRolesResponse sessionRolesResponse = (RbacSessionRolesResponse)ld.extended((ExtendedRequest)sessionRolesRequest);
            LOG.debug("sessionRoles result: {}", (Object)sessionRolesResponse.getLdapResult().getResultCode().getResultCode());
            if (CollectionUtils.isNotEmpty((Collection)sessionRolesResponse.getRoles())) {
                userRoleList = new ArrayList<UserRole>();
                for (String roleNm : sessionRolesResponse.getRoles()) {
                    userRoleList.add(new UserRole(session.getUserId(), roleNm));
                }
            }
        }
        catch (LdapException e) {
            String error = "sessionRoles caught LDAPException= msg=" + e.getMessage();
            throw new SecurityException(10206, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return userRoleList;
    }
}

