/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.intermediate;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreIntermediateResponseValue
extends GrammarAction<LdapMessageContainer<IntermediateResponse>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreIntermediateResponseValue.class);

    public StoreIntermediateResponseValue() {
        super("Store response value");
    }

    @Override
    public void action(LdapMessageContainer<IntermediateResponse> container) throws DecoderException {
        IntermediateResponse intermediateResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() >= 0) {
            IntermediateOperationFactory intermediateFactory = container.getIntermediateFactory();
            if (intermediateFactory != null) {
                intermediateFactory.decodeValue(intermediateResponse, tlv.getValue().getData());
            } else {
                intermediateResponse.setResponseValue(tlv.getValue().getData());
            }
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05175_VALUE_READ, Strings.dumpBytes(intermediateResponse.getResponseValue())));
        }
    }
}

