/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.ssl;

import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.filter.ssl.SslFilter;

public final class LdapsInitializer {
    private LdapsInitializer() {
    }

    public static IoFilterChainBuilder init(LdapServer ldapServer, TcpTransport transport) throws LdapException {
        List<String> enabledProtocols;
        SSLContext sslCtx;
        try {
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(ldapServer.getKeyManagerFactory().getKeyManagers(), ldapServer.getTrustManagers(), new SecureRandom());
        }
        catch (Exception e) {
            throw new LdapException(I18n.err(I18n.ERR_683, new Object[0]), e);
        }
        DefaultIoFilterChainBuilder chain = new DefaultIoFilterChainBuilder();
        SslFilter sslFilter = new SslFilter(sslCtx);
        List<String> cipherSuites = transport.getCipherSuite();
        if (cipherSuites != null && !cipherSuites.isEmpty()) {
            sslFilter.setEnabledCipherSuites(cipherSuites.toArray(new String[cipherSuites.size()]));
        }
        if ((enabledProtocols = transport.getEnabledProtocols()) != null && !enabledProtocols.isEmpty()) {
            sslFilter.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
        } else {
            sslFilter.setEnabledProtocols("TLSv1", "TLSv1.1", "TLSv1.2");
        }
        sslFilter.setNeedClientAuth(transport.isNeedClientAuth());
        sslFilter.setWantClientAuth(transport.isWantClientAuth());
        chain.addLast("sslFilter", sslFilter);
        return chain;
    }
}

