/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaUtils;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilteringOperationContext
extends AbstractOperationContext {
    protected static final Logger LOG = LoggerFactory.getLogger(FilteringOperationContext.class);
    protected Set<AttributeTypeOptions> returningAttributes;
    protected String[] returningAttributesString;
    private boolean allOperationalAttributes;
    private boolean allUserAttributes;
    private boolean noAttributes;
    protected boolean typesOnly = false;

    public FilteringOperationContext(CoreSession session) {
        this(session, "*");
    }

    public FilteringOperationContext(CoreSession session, Dn dn) {
        this(session, dn, "*");
    }

    public FilteringOperationContext(CoreSession session, String ... returningAttributes) {
        super(session);
        this.setReturningAttributes(returningAttributes);
    }

    public FilteringOperationContext(CoreSession session, Dn dn, String ... returningAttributes) {
        super(session, dn);
        this.setReturningAttributes(returningAttributes);
    }

    public Set<AttributeTypeOptions> getReturningAttributes() {
        return this.returningAttributes;
    }

    public String[] getReturningAttributesString() {
        return this.returningAttributesString;
    }

    public boolean contains(SchemaManager schemaManager, String attribute) {
        if (this.isNoAttributes()) {
            return false;
        }
        try {
            AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(attribute);
            return this.contains(schemaManager, attributeType);
        }
        catch (LdapException le) {
            return false;
        }
    }

    public boolean contains(SchemaManager schemaManager, AttributeType attributeType) {
        if (this.isNoAttributes()) {
            return false;
        }
        if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS && this.allUserAttributes) {
            return true;
        }
        if (attributeType.getUsage() != UsageEnum.USER_APPLICATIONS && this.allOperationalAttributes) {
            return true;
        }
        if (this.returningAttributes == null) {
            return false;
        }
        if (this.returningAttributes.contains(new AttributeTypeOptions(attributeType))) {
            return true;
        }
        for (AttributeTypeOptions attributeTypeOptions : this.returningAttributes) {
            if (!attributeTypeOptions.getAttributeType().equals(attributeType) && !attributeTypeOptions.getAttributeType().isAncestorOf(attributeType)) continue;
            return true;
        }
        return false;
    }

    public void setReturningAttributes(String ... attributeIds) {
        if (attributeIds != null && attributeIds.length != 0 && attributeIds[0] != null) {
            this.returningAttributes = new HashSet<AttributeTypeOptions>();
            HashSet<String> attributesString = new HashSet<String>();
            Set<AttributeTypeOptions> collectedAttributes = this.collectAttributeTypes(attributeIds);
            if (!collectedAttributes.isEmpty() || this.allUserAttributes || this.allOperationalAttributes) {
                this.noAttributes = false;
            }
            if (!collectedAttributes.isEmpty()) {
                for (AttributeTypeOptions attributeTypeOption : collectedAttributes) {
                    if (attributeTypeOption.getAttributeType().isUser() && !this.allUserAttributes) {
                        this.returningAttributes.add(attributeTypeOption);
                        attributesString.add(attributeTypeOption.getAttributeType().getOid());
                    }
                    if (!attributeTypeOption.getAttributeType().isOperational() || this.allOperationalAttributes) continue;
                    this.returningAttributes.add(attributeTypeOption);
                    attributesString.add(attributeTypeOption.getAttributeType().getOid());
                }
            }
            this.returningAttributesString = !attributesString.isEmpty() ? attributesString.toArray(ArrayUtils.EMPTY_STRING_ARRAY) : ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            this.allUserAttributes = true;
            this.returningAttributesString = ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    private Set<AttributeTypeOptions> collectAttributeTypes(String ... attributesIds) {
        HashSet<AttributeTypeOptions> collectedAttributes = new HashSet<AttributeTypeOptions>();
        if (attributesIds != null && attributesIds.length != 0) {
            for (String returnAttribute : attributesIds) {
                if (returnAttribute == null) continue;
                if (returnAttribute.equals("1.1")) {
                    this.noAttributes = true;
                    continue;
                }
                if (returnAttribute.equals("+")) {
                    this.allOperationalAttributes = true;
                    continue;
                }
                if (returnAttribute.equals("*")) {
                    this.allUserAttributes = true;
                    continue;
                }
                try {
                    String id = SchemaUtils.stripOptions(returnAttribute);
                    Set<String> options = SchemaUtils.getOptions(returnAttribute);
                    AttributeType attributeType = this.session.getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry(id);
                    AttributeTypeOptions attrOptions = new AttributeTypeOptions(attributeType, options);
                    collectedAttributes.add(attrOptions);
                }
                catch (LdapException le) {
                    LOG.warn("Requested attribute {} does not exist in the schema, it will be ignored", (Object)returnAttribute);
                }
            }
        }
        return collectedAttributes;
    }

    public void setAllOperationalAttributes(boolean allOperationalAttributes) {
        this.allOperationalAttributes = allOperationalAttributes;
    }

    public boolean isAllUserAttributes() {
        return this.allUserAttributes;
    }

    public void setAllUserAttributes(boolean allUserAttributes) {
        this.allUserAttributes = allUserAttributes;
    }

    public boolean isAllOperationalAttributes() {
        return this.allOperationalAttributes;
    }

    public boolean isNoAttributes() {
        return this.noAttributes;
    }

    public void setNoAttributes(boolean noAttributes) {
        this.noAttributes = noAttributes;
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FilteringOperationContext for Dn '");
        sb.append(this.dn.getName()).append("'");
        if (this.isTypesOnly()) {
            sb.append(", type only");
        }
        if (this.allOperationalAttributes) {
            sb.append(", +");
        }
        if (this.allUserAttributes) {
            sb.append(", *");
        }
        if (this.noAttributes) {
            sb.append(", 1.1");
        }
        if (this.returningAttributesString != null && this.returningAttributesString.length > 0) {
            sb.append(", attributes : <");
            boolean isFirst = true;
            for (String returningAttribute : this.returningAttributesString) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(returningAttribute);
            }
            sb.append(">");
        }
        return sb.toString();
    }
}

