/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.proxiedauthz;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.ProxiedAuthz;
import org.apache.directory.api.ldap.model.message.controls.ProxiedAuthzImpl;
import org.apache.directory.api.util.Strings;

public class ProxiedAuthzFactory
extends AbstractControlFactory<ProxiedAuthz> {
    public ProxiedAuthzFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.18");
    }

    @Override
    public ProxiedAuthz newControl() {
        return new ProxiedAuthzImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        byte[] authzId = Strings.getBytesUtf8(((ProxiedAuthz)control).getAuthzId());
        if (authzId != null) {
            buffer.put(authzId);
        }
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        try {
            ((ProxiedAuthz)control).setAuthzId(Strings.utf8ToString(controlBytes));
        }
        catch (RuntimeException re) {
            throw new DecoderException(re.getMessage());
        }
    }
}

