/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exclude.extension;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.exclude.Exclude;
import org.apache.deltaspike.core.api.interpreter.ExpressionInterpreter;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.impl.exclude.CustomProjectStageBeanFilter;
import org.apache.deltaspike.core.impl.interpreter.PropertyExpressionInterpreter;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.spi.filter.ClassFilter;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;

public class ExcludeExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(ExcludeExtension.class.getName());
    private boolean isActivated = true;
    private boolean isCustomProjectStageBeanFilterActivated = true;
    private ClassFilter classFilter;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        String activeClassFilterName;
        String classFilterClassName;
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        this.isCustomProjectStageBeanFilterActivated = ClassDeactivationUtils.isActivated(CustomProjectStageBeanFilter.class);
        boolean isClassFilterActivated = ClassDeactivationUtils.isActivated(ClassFilter.class);
        if (isClassFilterActivated && !(classFilterClassName = ClassFilter.class.getName()).equals(activeClassFilterName = ConfigResolver.getProjectStageAwarePropertyValue((String)classFilterClassName, (String)classFilterClassName))) {
            this.classFilter = (ClassFilter)ClassUtils.tryToInstantiateClassForName((String)activeClassFilterName, ClassFilter.class);
        }
    }

    protected void initProjectStage(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        ProjectStageProducer.getInstance();
    }

    protected void vetoBeans(@Observes ProcessAnnotatedType processAnnotatedType, BeanManager beanManager) {
        Class beanClass;
        if (this.isCustomProjectStageBeanFilterActivated) {
            this.vetoCustomProjectStageBeans(processAnnotatedType);
        }
        if (!this.isActivated) {
            return;
        }
        if (this.classFilter != null && this.classFilter.isFiltered(beanClass = processAnnotatedType.getAnnotatedType().getJavaClass())) {
            this.veto(processAnnotatedType, this.classFilter.getClass().getName());
            return;
        }
        ProjectStage projectStage = ProjectStageProducer.getInstance().getProjectStage();
        Exclude exclude = this.extractExcludeAnnotation(processAnnotatedType.getAnnotatedType().getJavaClass());
        if (exclude == null) {
            return;
        }
        if (!this.evalExcludeWithoutCondition(processAnnotatedType, exclude)) {
            return;
        }
        if (!this.evalExcludeInProjectStage(processAnnotatedType, exclude, projectStage)) {
            return;
        }
        if (!this.evalExcludeNotInProjectStage(processAnnotatedType, exclude, projectStage)) {
            return;
        }
        this.evalExcludeWithExpression(processAnnotatedType, exclude);
    }

    protected Exclude extractExcludeAnnotation(Class<?> currentClass) {
        Exclude result = currentClass.getAnnotation(Exclude.class);
        if (result != null) {
            return result;
        }
        for (currentClass = currentClass.getSuperclass(); !Object.class.equals(currentClass) && currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (Modifier.isAbstract(currentClass.getModifiers())) {
                result = currentClass.getAnnotation(Exclude.class);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected void vetoCustomProjectStageBeans(ProcessAnnotatedType processAnnotatedType) {
        if (ProjectStage.class.isAssignableFrom(processAnnotatedType.getAnnotatedType().getJavaClass())) {
            processAnnotatedType.veto();
        }
    }

    private boolean evalExcludeWithoutCondition(ProcessAnnotatedType processAnnotatedType, Exclude exclude) {
        if (exclude.ifProjectStage().length == 0 && exclude.exceptIfProjectStage().length == 0 && "".equals(exclude.onExpression())) {
            this.veto(processAnnotatedType, "Stateless");
            return false;
        }
        return true;
    }

    private boolean evalExcludeInProjectStage(ProcessAnnotatedType processAnnotatedType, Exclude exclude, ProjectStage currentlyConfiguredProjectStage) {
        Class[] activatedIn = exclude.ifProjectStage();
        if (activatedIn.length == 0) {
            return true;
        }
        if (this.isInProjectStage(activatedIn, currentlyConfiguredProjectStage)) {
            this.veto(processAnnotatedType, "IfProjectState");
            return false;
        }
        return true;
    }

    private boolean evalExcludeNotInProjectStage(ProcessAnnotatedType processAnnotatedType, Exclude exclude, ProjectStage currentlyConfiguredProjectStage) {
        Class[] notIn = exclude.exceptIfProjectStage();
        if (notIn.length == 0) {
            return true;
        }
        if (!this.isInProjectStage(notIn, currentlyConfiguredProjectStage)) {
            this.veto(processAnnotatedType, "ExceptIfProjectState");
            return false;
        }
        return true;
    }

    private void evalExcludeWithExpression(ProcessAnnotatedType processAnnotatedType, Exclude exclude) {
        if ("".equals(exclude.onExpression())) {
            return;
        }
        if (this.isDeactivated(exclude, PropertyExpressionInterpreter.class)) {
            this.veto(processAnnotatedType, "Expression");
        }
    }

    private boolean isInProjectStage(Class<? extends ProjectStage>[] activatedIn, ProjectStage currentlyConfiguredProjectStage) {
        if (activatedIn != null && activatedIn.length > 0) {
            for (Class<? extends ProjectStage> activated : activatedIn) {
                if (!currentlyConfiguredProjectStage.getClass().equals(activated)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeactivated(Exclude exclude, Class defaultExpressionInterpreterClass) {
        ExpressionInterpreter expressionInterpreter;
        String expressions = exclude.onExpression();
        Class interpreterClass = exclude.interpretedBy();
        if (interpreterClass.equals(ExpressionInterpreter.class)) {
            interpreterClass = defaultExpressionInterpreterClass;
        }
        if ((expressionInterpreter = (ExpressionInterpreter)ClassUtils.tryToInstantiateClass((Class)interpreterClass)) == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("can't instantiate " + interpreterClass.getClass().getName());
            }
            return true;
        }
        return (Boolean)expressionInterpreter.evaluate((Object)expressions);
    }

    private void veto(ProcessAnnotatedType processAnnotatedType, String vetoType) {
        processAnnotatedType.veto();
        LOG.finer(vetoType + " based veto for bean with type: " + processAnnotatedType.getAnnotatedType().getJavaClass());
    }

    private static String getJarVersion(Class targetClass) {
        String manifestFileLocation = ExcludeExtension.getManifestFileLocationOfClass(targetClass);
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getManifestFileLocationOfClass(Class targetClass) {
        String manifestFileLocation;
        try {
            manifestFileLocation = ExcludeExtension.getManifestLocation(targetClass);
        }
        catch (Exception e) {
            manifestFileLocation = ExcludeExtension.getManifestLocation(targetClass.getSuperclass());
        }
        return manifestFileLocation;
    }

    private static String getManifestLocation(Class targetClass) {
        String classFilePath = targetClass.getCanonicalName().replace('.', '/') + ".class";
        String manifestFilePath = "/META-INF/MANIFEST.MF";
        String classLocation = targetClass.getResource(targetClass.getSimpleName() + ".class").toString();
        return classLocation.substring(0, classLocation.indexOf(classFilePath) - 1) + manifestFilePath;
    }
}

